<?php

namespace App\Livewire;

use Livewire\Component;
use Illuminate\Support\Str;
use App\Mail\ContactMailable;
use App\Models\ContactRequest;
use Illuminate\Support\Facades\Mail;
use Jantinnerezo\LivewireAlert\LivewireAlert;
use Livewire\Features\SupportFileUploads\WithFileUploads;

class ContactRequestPost extends Component
{
    use LivewireAlert;
    use WithFileUploads;


    public $email;
    public $country;
    public $username;
    public $messageEmail;
    public $company;
    public $file;
    public $dataDivision;

    protected  $rules = [
        'username' => "required|string|max:100",
        'country' =>   "required|string|max:50",
        'company' =>  "required|string|max:100",
        'email' => 'required|email|max:100',
        'file' => 'nullable|file|mimes:jpg,jpeg,png,pdf,doc,docx|max:3072',
        'messageEmail' => 'required|string',

    ];

    public function render()
    {
        return view('livewire.contact-request-post');
    }

    public function store()
    {
        #validate
        $this->validate();

        //content Email
        $contentEmail = $this->emailContent();
        $title        = "New contact message";
        $subject      = 'New contact message';

        try {
            $filePath = null;
            $nameFile = null;
            if($this->file){
                $nameFile = Str::uuid() .  "." . $this->file->extension();
                $filePath     = $this->file->storeAs('files-form', $nameFile);
            }
            #send email
            Mail::to('info@group-itg.com')
            ->bcc(['ismaharo18@gmail.com', 'luiscastellanos.dv@gmail.com'])
            ->send(new ContactMailable($contentEmail, $title, $subject, $filePath ));
            #save information
            ContactRequest::create([
                'email'         => $this->email,
                'country'       => $this->country,
                'name'          => $this->username,
                'message'       => $this->messageEmail,
                'company'       => $this->company,
                'file'          =>  $nameFile,
                'division_id'   => $this->dataDivision->id,
            ]);
            #Clean form
            $this->cleanForm();
            #message success
            $this->alert('success', __('messages.success-email'));
            session()->flash('messageSuccess', __('messages.success-email'));
        } catch (\Exception $e) {
            #message error
            session()->flash('error_message', $e);
            $this->alert('error', __('messages.error-email'));
        }
    }


    public function emailContent()
    {
        //info form email
        $content = '
        
        <h3 style="margin-bottom: 20px;">Hello, ' . $this->username  . ' wants to
            contact you!
        </h3>
        <p><strong>Name: </strong>' . $this->username  . '</p>
        <p><strong>Email: </strong>' . $this->email  . '</p>
        <p><strong>Country: </strong>' . $this->country  . '</p>
        <p><strong>Company: </strong>' . $this->company  . '</p>
        <p><strong>Division visited: </strong>' . $this->dataDivision->name  . '</p>
        <p><strong>Inquiry: </strong></p>
        <p>' . $this->messageEmail  . '</p> 
        ';

        return $content;
    }

    public function cleanForm()
    {
        $this->username = '';
        $this->country = '';
        $this->email = '';
        $this->company = '';
        $this->file = '';
        $this->messageEmail = '';
    }
}
