<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class BlogCategory extends Model
{
    use HasFactory;

    #query to Blogs (hasMany)
    public function blogs()
    {
        return $this->hasMany(Blog::class);
    }

    #query to BlogCategoryTranslations (hasMany)
    public function blogCategoryTranslations()
    {
        return  $this->hasMany(BlogCategoryTranslation::class);
    }
    
    #query to BlogCategoryTranslation(hasOne)
    public function translation()
    {
        // $lang = Language::getLanguage();
        $lang  = session('langSet');
        return $this->hasOne(BlogCategoryTranslation::class)->where('language_id', $lang->id);
    }
}
