<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class BlogTag extends Model
{
    use HasFactory;

    #query to BlogTagTranslations(hasOne)
    public function translation()
    {
        $lang  = session('langSet');
        return $this->hasOne(BlogTagTranslation::class)->where('language_id', $lang->id);
    }


    #query to Blogs(belogsToMany)
    public function blogs()
    {
        return $this->belongsToMany(Blog::class, 'blog_tag_rels');
    }
}
