<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class MachineCategory extends Model
{
    use HasFactory;

    #query to Machine (hasMany)
    public function machines(){
        return $this->hasMany(Machine::class);
    }

        #query to MachineCategoryTranslation (hasOne)
    public function translation(){
        $lang  = session('langSet');
        return $this->hasOne(MachineCategoryTranslation::class)->where('language_id', $lang->id);
    }
}
