<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ProductSector extends Model
{
    use HasFactory;

    #query to productCategories (hasMany)
    public function productCategory()
    {
        return  $this->hasMany(ProductCategory::class);
    }

    #query to productSectorTranslations (hasMany)
    public function productSectorTranslations()
    {
        return  $this->hasMany(ProductSectorTranslation::class);
    }

    #query to ProductSectorTranslation(hasOne)
    public function translation()
    {
        $lang  = session('langSet');
        return $this->hasOne(ProductSectorTranslation::class)->where('language_id', $lang->id);
    }

    #query to pdf_sector (hasOne)
    public function  cataloguePdf(){
        $lang  = session('langSet');
        return $this->hasOne(PdfSector::class, 'product_sector_id')->whereIn('language_id', [$lang->id, 2])
        ->orderByRaw("FIELD(language_id, $lang->id, 2)");
    }
}
