<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Specialty extends Model
{
    use HasFactory;

    #query to translationSpecialties
    public function translationSpecialties()
    {
        return $this->hasMany(SpecialtyTranslation::class);
    }
    
    #query to SpecialtyTranslation(hasOne)
    public function translation()
    {
        $lang  = session('langSet');
        return $this->hasOne(SpecialtyTranslation::class)->where('language_id', $lang->id);
    }
}
