<?php

namespace App\Providers;

use App\Models\ProductSector;
use App\Models\MachineCategory;
use Illuminate\Support\Facades\View;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\ServiceProvider;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        //
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        View::composer('*', function ($view) {
            static $cachedData = null;

            if (is_null($cachedData)) {
                $categories = MachineCategory::with('translation')->get();
                $sectors = ProductSector::with('translation')->get();
                $cachedData = [
                    'machineCategories' => $categories,
                    'productCategories' => $sectors
                ];
            }

            $view->with($cachedData);
        });
    }
}
