<?php
// app/Utils/SEOUtil.php

namespace App\Utils;

class SeoUtil
{



    // The SEO data will be dynamic depending on the subdomain found in the URL,
    // so when obtaining the parameter of the function it will return the data of each subdomain
    public static function getSeoData($subdomain, $info = null)
    {


        $lang = app()->getLocale();

        $keywords = KeywordsUtil::generalKeywords();

        $data = [
            //home
            'home.index' => [
                'title' =>  __('messages.seo-title-home'),
                'description' => __('messages.seo-description-home'),
                'keyword' => ""
            ],
            //about
            'about.index' => [
                'title' => __('messages.seo-title-about'),
                'description' => __('messages.seo-description-about'),
                'keyword' => ""
            ],
            //partners
            'partners.index' => [
                'title' => __('messages.seo-title-partners'),
                'description' => __('messages.seo-description-partners'),
                'keyword' => ""
            ],
            //contacts
            'contact.index' => [
                'title' => __('messages.seo-title-contacts'),
                'description' => __('messages.seo-description-contacts'),
                'keyword' => ""
            ],
            //blog
            'blog.index' => [
                'title' => __('messages.seo-title-blogs'),
                'description' => __('messages.seo-description-blogs'),
                'keyword' => ""
            ],

            'blog.category' => [
                'title' => __('messages.seo-title-' . $info),
                'description' => __('messages.seo-description-' . $info),
                'keyword' => ""
            ],
            //blog.show
            'blog.show' => [
                'title' => __('Blog ITG Group :' . $info),
                'description' => __($info),
                'keyword' => ""
            ],
            //products
            'products.index' => [
                'title' => __('messages.seo-title-products'),
                'description' => __('messages.seo-description-products'),
                'keyword' => ""
            ],
            'products.sector' => [
                'title' => __('messages.seo-title-product-' . $info),
                'description' => __('messages.seo-description-product-' . $info),
                'keyword' => $keywords[$lang][$info . "-product"] ?? null,
            ],
            //Machinery
            'machinery.new-machinery' => [
                'title' => __('messages.seo-title-new-machinery'),
                'description' => __('messages.seo-description-new-machinery'),
                'keyword' => ""
            ],
            'machinery.index' => [
                'title' => __('messages.seo-title-machinery'),
                'description' => __('messages.seo-description-machinery'),
                'keyword' => ""
            ],
            'machinery.show' => [
                'title' => __('messages.seo-title-machinery-' . $info),
                'description' => __('messages.seo-description-machinery-' . $info),
                'keyword' => ""
            ],
            'machinery.category' => [
                'title' => __('messages.seo-title-machinery-' . $info),
                'description' => __('messages.seo-description-machinery-' . $info),
                'keyword' => $keywords[$lang][$info . "-machinery"] ?? null,
            ],
            'sitemap.index' => [
                'title' => "",
                'description' => "",
                'keyword' => ""
            ],
            // 'error.404' => [
            //     'title' => "Error, Page not found",
            //     'description' => "Error 404",
            //     'keyword' => ""
            // ]

        ];

        $contentMeta = '2rcXrPXLFLqZH3zntOWXqPTaMDjzPBDbnxHIz8Cy-ys';

        // return $data;
        return [
            'data' => $data,
            'contentMeta' => $contentMeta
        ];
    }
}
