<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('contact_requests', function (Blueprint $table) {
            $table->id()->comment('Id');
            $table->string('email', 100)->comment('Contact E-Mail');;
            $table->string('country', 50)->comment('Country of origin');
            $table->string('name', 100)->comment('Full name');
            $table->text('message')->comment('Message to send');
            $table->string('phone', 15)->comment('Telephone contact');
            $table->foreignId('division_id')->constrained()->onDelete('cascade')->comment('Foreing Id table divisions');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('contact_requests');
    }
};
