<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('contact_interest_mails', function (Blueprint $table) {
            $table->id()->comment('Id');
            $table->string('email', 100)->comment('Contact E-Mail');;
            $table->foreignId('division_id')->constrained()->onDelete('cascade')->comment('Foreing Id table divisions');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('contact_interest_mails');
    }
};
