<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('contact_careers', function (Blueprint $table) {
            $table->id()->comment('Id');
            $table->string('email', 100)->comment('Contact E-Mail');;
            $table->string('name', 100)->comment('Full name');
            $table->text('message')->comment('Message to send');
            $table->string('file_cv')->comment('cv file');
            $table->integer('division')->comment('division of interest');
            $table->foreignId('specialty_id')->constrained()->onDelete('cascade')->comment('Foreing Id table Specialty');
            $table->foreignId('division_id')->constrained()->onDelete('cascade')->comment('Foreing Id table divisions');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('contact_careers');
    }
};
