<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('machines', function (Blueprint $table) {
            $table->id();
            $table->integer('main_image')->comment('Main image');
            $table->integer('status')->default(1)->comment('status of machine'); // 1 for active, 0 for inactive
            // $table->integer('condition')->default(0)->comment('Condition of product'); // 0 for new, 1 for used
            $table->string('data_sheet')->comment('data sheet of machine');
            $table->foreignId('machine_category_id')->constrained()->onDelete('cascade')->comment('Foreing Id table machine_categories');
            $table->foreignId('division_id')->constrained()->onDelete('cascade')->comment('Foreing Id table division');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('machines');
    }
};
