<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('machine_translations', function (Blueprint $table) {
            $table->id();
            $table->string('name', 100)->comment('Machine name');
            $table->text('description')->comment('Machine description');
            $table->foreignId('machine_id')->constrained()->onDelete('cascade')->comment('Foreing Id table machines');
            $table->foreignId('language_id')->constrained()->onDelete('cascade')->comment('Foreing Id table languages');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('machine_translations');
    }
};
