<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('pdf_sectors', function (Blueprint $table) {
            $table->id();
            $table->string('pdf_catalogue')->comment('Catalogue of product sector');
            $table->foreignId('product_sector_id')->constrained()->onDelete('cascade')->comment('Foreing Id table product_sectors');
            $table->foreignId('language_id')->constrained()->onDelete('cascade')->comment('Foreing Id table languages');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('pdf_sectors');
    }
};
