<?php

namespace Database\Seeders;

// use Faker\Factory as Faker;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class BlogTagRelSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {

        // Check if we are sowing or reversing
        $rollback = env('SEED_ROLLBACK', false);

        if ($rollback) {
            // Temporarily disable foreign key restrictions
            DB::statement('SET FOREIGN_KEY_CHECKS = 0;');
            // Truncate all blog_tag_rels
            DB::table('blog_tag_rels')->truncate();
        } else {

            // $faker = Faker::create();

            $blogtags = DB::table('blog_tags')->pluck('id')->toArray();
            $blogs    = DB::table('blogs')->pluck('id')->toArray();


            foreach ($blogs as $blog) {
                foreach ($blogtags as $blogtag) {
                    foreach (range(1, 8) as $index) {
                        DB::table('blog_tag_rels')->insert([
                            // 'id' => $index,
                            'blog_tag_id' => $blogtag,
                            'blog_id' => $blog,
                            'created_at' => now(),
                            'updated_at' => now(),
                        ]);
                    }
                }
            }
        }
    }
}
