<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Faker\Factory as Faker;

class BlogTagTranslationSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {

        // Check if we are sowing or reversing
        $rollback = env('SEED_ROLLBACK', false);

        if ($rollback) {
            // Temporarily disable foreign key restrictions
            DB::statement('SET FOREIGN_KEY_CHECKS = 0;');
            // Truncate all blog_tag_translations
            DB::table('blog_tag_translations')->truncate();
        } else {
            $faker = Faker::create();
            $blogTags = DB::table('blog_tags')->pluck('id')->toArray();
            $languages = DB::table('languages')->pluck('id')->toArray();

            foreach ($blogTags as $blogTagId) {
                foreach ($languages as $languageId) {
                    DB::table('blog_tag_translations')->insert([
                        // 'id' => $index,
                        'name' => $faker->word,
                        'blog_tag_id' => $blogTagId,
                        'language_id' =>  $languageId,
                        'created_at' => now(),
                        'updated_at' => now(),
                    ]);
                }
            }
        }
    }
}
