<?php

namespace Database\Seeders;

// use Faker\Factory as Faker;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class GalleryBlogImages extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Check if we are sowing or reversing
        $rollback = env('SEED_ROLLBACK', false);

        if ($rollback) {
            // Temporarily disable foreign key restrictions
            DB::statement('SET FOREIGN_KEY_CHECKS = 0;');
            // Truncate all blogs
            DB::table('gallery_blog_images')->truncate();
        } else {


            $images = [
                // '1' => [
                //     "gallery/itg brazil/Articulo Existente_Kern.3.jpg",
                //     "gallery/itg brazil/Articulo Existente_Kern.2.jpg",

                // ],
                // '2' => [
                //     "gallery/crecimiento-expo/1.jpg",
                //     "gallery/crecimiento-expo/2.jpg",
                //     "gallery/crecimiento-expo/3.jpg",
                //     "gallery/crecimiento-expo/4.jpg",
                //     "gallery/crecimiento-expo/5.jpg",
                //     "gallery/crecimiento-expo/6.jpg",
                //     "gallery/crecimiento-expo/7.jpg",
                // ],
                // '3' => [
                //     "gallery/data/Imagen 01 .png",
                //     "gallery/data/Imagen 02.png",
                // ],
                // '4' => [
                //     "gallery/sistentable/Image 01.png",
                //     "gallery/sistentable/Image 02.png",
                //     "gallery/sistentable/Image 03.png",
                // ],
                // '5' => [
                //     "gallery/tdpp/Image 01.png",
                //     "gallery/tdpp/Image 02.png",
                // ],
                // '6' => [
                //     "gallery/ut2025/Image 01.png",
                //     "gallery/ut2025/Image 02.png",
                // ],
                // '7' => [
                //     "chile/Imágenes complementarias/Image01.png",
                //     "chile/Imágenes complementarias/Image02.png",
                // ],
                // '8' => [
                //     "Adidas/Imágenes complementarias/Image01.png",
                //     "Adidas/Imágenes complementarias/Image02.png",
                // ],

                // // 9 = sin image
                // '10' => [
                //     "Consumidor/Imágenes complementarias/Image 01.png",
                //     "Consumidor/Imágenes complementarias/Image 02.png",
                // ],
                // '11' => [
                //     "blog 4.0 industria/Imágenes complementarias/Image 01.png",
                //     "blog 4.0 industria/Imágenes complementarias/Image 02.png",
                // ],

                // 13 = Athleisure
                // '13' => [
                //     "Athleisure/Imagen complementarias /image_01.png",
                // ],

                #14
                '14' => [
                    "Sustainable/Imágenes complementarias/Imagen 01.png",
                    "Sustainable/Imágenes complementarias/Imagen 02.png",
                ],


            ];

            // '' => [
            //     "",
            //     "",
            //                        ],

            foreach ($images as $key => $imageArray) {
                if (!empty($imageArray)) {
                    foreach ($imageArray as $image) {
                        DB::table('gallery_blog_images')->insert([
                            // 'id' => $index,
                            'name' => $image,
                            'blog_id'     => $key,
                            'created_at' => now(),
                            'updated_at' => now(),
                        ]);
                    }
                }
            }
        }
    }
}
