<?php

namespace Database\Seeders;

// use Faker\Factory as Faker;
use Illuminate\Support\Str;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class MachineCategorySeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {

        // Check if we are sowing or reversing
        $rollback = env('SEED_ROLLBACK', false);

        if ($rollback) {
            // Temporarily disable foreign key restrictions
            DB::statement('SET FOREIGN_KEY_CHECKS = 0;');
            // Truncate all machine_categories
            DB::table('machine_categories')->truncate();
        } else {
            // $faker = Faker::create();

            $name = ["Weaving", "Warping", "Label weaving", "Knitting", "Braiding", "Sizing","Finishing"];


                foreach ($name as $value) {
                    DB::table('machine_categories')->insert([
                        // 'id' => $index,
                        'name' => Str::slug($value),
                        'created_at' => now(),
                        'updated_at' => now(),
                    ]);
                }
        }
    }
}
