<?php

namespace Database\Seeders;

// use Faker\Factory as Faker;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class MachineFeatureSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {

        // Check if we are sowing or reversing
        $rollback = env('SEED_ROLLBACK', false);

        if ($rollback) {
            // Temporarily disable foreign key restrictions
            DB::statement('SET FOREIGN_KEY_CHECKS = 0;');
            // Truncate all machine_features
            DB::table('machine_features')->truncate();
        } else {

            // $faker = Faker::create();
            $features = $this->data();
            foreach ($features as $feature) {
                $machineId = $feature['product'];
                foreach ($feature["features"] as $featurename) {

                    DB::table('machine_features')->insert([
                        // 'id' => $index,
                        'name' =>  substr($featurename, 0, 50),
                        'machine_id' => $machineId,
                        'created_at' => now(),
                        'updated_at' => now(),
                    ]);
                }
            }
        }
    }


    public function data()
    {
        return   [
            //water looms
            [
                'product' => 1,
                'features' => [
                    "Highly strengthened frames ensure stable insertion and excellent performance.",    // inglés
                    "New type ceramic nozzles can enhance the stability of insertion during high speed running.",    // inglés
                    "It is easy for this type of looms to weave finest and thickness yarns, narrow and wide fabrics.",    // inglés
                    "Perfect service pre-sales, sales and after sales.",    // inglés
                ]
            ],
            //rapier
            [
                'product' => 2,
                'features' => [
                    "Designed for power saving, high-speed & high efficiency, low vibration & low noise.",    // inglés
                    "More than 15% power can be saved than normal motors.",    // inglés
                    "Direct motor in high speed or stepless speed change.",    // inglés
                    "Humanized and friendly interface for customers make operation easy and quick.",    // inglés
                    "Adopts big LCD screen display which can make intercommunication and instant setting.",    // inglés
                    "Speed is controlled by the most advanced SRD system to ensure perfect fabric quality and save power",    // inglés
                ]
            ],
            //terry looms
            [
                'product' => 3,
                'features' => [
                    "New type positive pile back-rest roller, newtype loop formation unit and new groundback-rest roller, these new designs can ensure the bet quality and functions of this machine.",    // inglés
                    "Low vibration pattern at high speed and efficiency.",    // inglés
                    "Best balance between consumption and performance with minimal noise and vibrations.",    // inglés
                    "RFTL series adopt centralization lubrication. Oil can be filtered through double filters.",    // inglés
                ]
            ],
            //air looms
            [
                'product' => 4,
                'features' => [
                    "The stable weft insertion, optimized shedding mechanism and robust frame structure ensure the loom keep excellent performance at ultra igh-speed.",    // inglés
                    "Intelligent control of air ducts.",    // inglés
                    "Variable speed drive directly with the main motor.",    // inglés
                    "Weaving Expert System can scout the working situation during loom running, can guide the loom to choose the best weaving technoogy.",    // inglés
                    "Optional Jacquard: For high value-added fabrics weaving such as tie, label, towels, upholster fabrics, silk, etc.",    // inglés
                ]
            ],
            //sectional warping machi
            [
                'product' => 6,
                'features' => [
                    "Machine suitable for warping various kinds of yarn, high twisted synthetic filaments, yarn-dyed fabric, silk fabric, toweling fabric and fabric in special industry.",    // inglés
                    "Compatible with different types of looms. Perfect equipment for preparation before weaving.",    // inglés
                    "Work width: 2300 - 4800 (mm) - Can be made per customer's demand",    // inglés
                    "Spindle numbers: 640, 720, 800, 960 end - Can be made per customer's demand",    // inglés
                    "Different types of creel according to customer's needs. (Fixed, V-shaped, etc)",    // inglés
                ]
            ],
            //direct warping
            [
                'product' => 7,
                'features' => [
                    "Can accurately control the length and arrangement of warp yarn.",    // inglés
                    "High efficiency, uniform density and flatness thread.",    // inglés
                    "Work width: 1600, 1800, 2000, 2200, 2400 (mm) - Can be made per customer's demand.",   // inglés,
                    "Speed of beam warping: 300 -1200m /min -Spindle numbers: 640 - 960 end -",    // inglés
                    "Can be made per customer’s demand",    // inglés
                ]
            ],
            //label weaving

            [
                'product' => 8,
                'features' => [
                    "Width loom: 1700 mm - 1900 mm",    // inglés
                    "High-speed electronic Jacquard with capacity from 1800 to 9600 hooks",    // inglés
                    "Equipped with a balanced lifting mechanism which eliminates load unbalance and works without vibration",    // inglés
                    "Controller with tracking of the quantity of labels to be produced and automatic continuation to the next design set",    // inglés
                    "Harness with quick coupling and easy assembly",    // inglés
                ]
            ],
            //narrow fabric
            [
                'product' => 9,
                'features' => [
                    "Jacquard head is high-speed and running smoothly",    // inglés
                    "Modules with separate control board, more convenient, efficient to maintain",    // inglés
                    "New control system which can store from 8 to 16 patterns and pattern up to 13,000 weft",    // inglés
                    "Optional variety of special device to match production of different products",    // inglés
                    "Spring type creel is stable and endurable, easy to adjust the tension of the yarn.",    // inglés
                    "Available in different widths, hooks and number of lines.",    // inglés
                ]
            ],
            //higt speed
            [
                'product' => 10,
                'features' => [
                    "Accurate performance, compatible and durable spare parts. Easy maintenance and adjustment.",    // inglés
                    "From 2 to 12 lines concurrent weaving.",    // inglés
                    "From the smallest width 3mm to the maximum width of 110mm. Various thicknesses from gauze tape to heavy tape.",    // inglés
                    "Convertible machines supported with various devices to provide a wide range of fabrics multi-requirements for a single machine as well.",   // inglés
                    "Available in different widths, hooks and number of lines.",    // inglés
                ]
            ],
            //automatic
            [
                'product' => 11,
                'features' => [
                    "Fixed back-and-forth weft drive for easy adjustment of kinetic pitches.",    // inglés
                    "Weft transmission-diversified weft gearing for successful looming",    // inglés
                    "Weft/rubber device separator for easy management of warp in handy operation that saves time and effort",    // inglés
                    "The mechanism of cranks delivers precision output and fits all types of gauge without grinding",    // inglés
                    "Multi head multi model yarn frame",    // inglés
                ]
            ],
            //Label & Folding machine
            [
                'product' => 12,
                'features' => [
                    "Suitable for multi-functional cutting and folding, with hot & cold blade cutting. ",
                    "High speed, higher precision and longer service life.",
                    "No need to change mould.",
                    "For different technique parameters such as end fold, centre fold, mitre fold and others.",
                    "No need to use tool when setting length."
                ]
            ],
            //ultrasonic
            [
                'product' => 13,
                'features' => [
                    "Fixed back-and-forth weft drive for easy adjustment of kinetic pitches.",
                    "Weft transmission-diversified weft gearing for successful looming.",
                    " Weft/rubber device separator for easy management of warp in handy operation that saves time and effort.",
                    "The mechanism of cranks delivers precision output and fits all types of gauge without grinding.",
                    "Multi head multi model yarn frame.",
                ]
            ],
            //Single jersey
            [
                'product' => 14,
                'features' => [
                    "Single jersey open width, velour terry, polar terry.",
                    "Parts and accessories are manufactured by the advanced machining center so that the precision and accuracy can be  greatly improved.",
                    "Gauge: 12G-44G",
                    " With a compact structure the newly designed central stitch system works smoothly and steadily and adjusts fabric weight simply and accurately which helps improve efficiency.",
                ]
            ],
            //interlock
            [
                'product' => 15,
                'features' => [
                    "Dual dedusting system of cylinder.",
                    "Unique drive system with especially dual tracks reduces wear and makes the machine run smoothly with less barre marks",
                    "Dial cam box base and the bush sleeve move synchronously, which  makes the adjustment of needle and space simply and accurately.",
                    "Operation is easy and convenient.",
                    "It removes creases from cloth, making it suitable for double air layer fabrics like high-quality nylon, polyester, and filament.",
                ]
            ],
            //single computer
            [
                'product' => 16,
                'features' => [
                    "Cylinder diameter: 12” - 44”",
                    "Gauge: 7G - 32G",
                    "With LCD display screen to simply the operation.",
                    "No specific software are needed for graphics.",
                    "Characterized by simple interchanging between single jacquard and mesh jacquard which can be realized by only replacing the cylinder cams, which greatly reduces the workload of testing."
                ]
            ],
            //Double computer
            [
                'product' => 17,
                'features' => [
                    "Cylinder diameter: 17” - 42”",
                    "Gauge: 7G - 32G",
                    "The machine uses computerized selectors to select needles in the cylinder with the 2- or 3-way knit, pick and skip technique, allowing to produce fabrics with different patterns without limitations. ",
                    "Any intricate pattern can be converted into a special command through the computerized pattern preparation system, which instructs the selectors to create jacquard fabric."
                ]
            ],
            //sock machine
            [
                'product' => 18,
                'features' => [
                    "For different types of applications: plain, terry and double terry.",
                    "Number of one to multiple incoming lines.",
                    "Needle range: 40 - 200 needles",
                    "Single cylinder",
                    "Running speed: 280 -  330 RPM",
                    "Feed: One/two feeds",
                    "Automatic yarn feeding",
                    "13 side yarn shuttles",
                    "Hosiery machine needles meet the requirements of normal knitting production.",
                    "When the power supply is interrupted, the system can retain the program and data in execution and system continue to execute the  program after the power supply is restored."
                ]
            ],
            //Braiding machines
            [
                'product' => 19,
                'features' => [
                    "Braiding machines ranging from 3 spindles to 640 spindles, in order to meet the various needs of different industries, fields, users.",
                    "Braiding machinery products cover a wide range of daily civil applications such as shoelace, garments accessories, belts, shoe material, fishing lines, fishing nets, wire and cable, and sport cord, also application in the medical, petrochemical, automotive, marine rope, aerospace, military and composites.",
                    "Machines can run 24 hours/7 days without change bobbins (depends on yarn size).",
                    "Auto-stop motion, inverter has various functions, can count meters, adjust speed, set current protection, record production time and set output. This machine can be equipped with rubber feeder depending to customer needs.",
                ]
            ],
            //Tipping machines
            [
                'product' => 20,
                'features' => [
                    "Adjustment of the length of the laces",
                    "Available in different sizes according to laces length.",
                    "In automatics, length from 0.40 to 2.2 meters.",
                    "In automatic, output from 4,000 to 6,000 pieces per hour.",
                    "For simple ribbon without logo for shoelace or for bag handle.",
                    "For acetate tips with or without logo."
                ]
            ],
            //Winding machines
            [
                'product' => 21,
                'features' => [
                    "Different types of winding machines:",
                    "Easy installation and adjustment.",
                    "For bobbins of different sizes.",
                    "With thread cutting device."
                ]
            ],
            //nnedle machines
            [
                'product' => 22,
                'features' => [
                    "60-120 meters/hour output",
                    "For different needle sizes.",
                    "For flat and round rope.",
                    "With and without heating device.",
                    "Availability of spare parts for this machine.",
                ]
            ],
            //sizing
            [
                'product' => 23,
                'features' => [
                    "Defined width: 3,000mm.",
                    "Working width: 1,800mm.",
                    "Winding diameter: 1,000/1,100mm.",
                    "Box temperature: 0-100oC.",
                    "Machine speed: 0.5-120 m/min."
                ]
            ],
            //stenter m
            [
                'product' => 24,
                'features' => [
                    "Can be adapted to different widths.",
                    "Mechanical speed adjustable according to chamber quantity and fabric type.",
                    "Heat source: Natural gas, heat transfer oil, electricity, steam.",
                    "It is suggested to create a customized quotation adapted to the needs of each client. For this, it is suggested that you contact your sales representative."
                ]
            ],
            //Dye jigg
            [
                'product' => 25,
                'features' => [
                    "Advanced AC frequency invert driving, PLC control and data communication technology are used.",
                    "Excellent human-computer interface dialogue function.",
                    "Auto-temperature control, auto direction reversing, auto record cycles, auto stop and fabric swing function.",
                    "Constant control of tension.",
                    "Advanced design, reasonable structure, wide adaptability, excellent performance, simple and convenient maintenance, safe and reliable operation.",
                    "Max. working width: 1,400 - 3,600 mm."
                ]
            ],

            //Electronic Jacquard
            [
                'product' => 5,
                'features' => [
                    "Optimal machine construction, especially for high speed, high load production weaving, and maximum flexibility.",
                    "Supporting all kinds of weaving machines (rapier, piece shuttle, air jet, water jet, etc.)",
                    "Very robust, wear-resistant, and designed for many years of daily use with a minimum of maintenance.",
                    "Cam in the inner of closed tank system, minimize wear and tear, extend working life.",
                    "Available with a different number of hooks and network function to transfer the pattern design."
                ]
            ],



            //
            // [
            //     'product' => 1,
            //     'features' => [
            //         ""
            //     ]
            // ],


        ];
    }
}
