<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
// use Faker\Factory as Faker;

class MachineTranslationSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {

        // Check if we are sowing or reversing
        $rollback = env('SEED_ROLLBACK', false);

        if ($rollback) {
            // Temporarily disable foreign key restrictions
            DB::statement('SET FOREIGN_KEY_CHECKS = 0;');
            // Truncate all machine_translations
            DB::table('machine_translations')->truncate();
        } else {
            // $faker = Faker::create();
            // $machines = DB::table('machines')->pluck('id')->toArray();
            // $languages = DB::table('languages')->pluck('id')->toArray();

            //? languageS -------------   [1] = Español, [2] 2 = Inglés, [3]  3 = Italiano, [4]  4 = Portugués, [5]   5 = Francés, [6]  6 = Chino ------------------------------

            $machines = [
                '1' => [
                    'name' => [
                        "Telares a chorro de agua",    // Español
                        "Water Looms",    // Inglés
                        "Telai a getto d'acqua",    // Italiano
                        "Tear Jato de água",    // Portugués
                        "Métiers à jet d'eau",    // Francés
                        "水喷织机",    // Chino
                    ],
                    'description' => [
                        "Los telares a chorro de agua están diseñados para alta velocidad, bajo consumo y un amplio rango de tejido. El mecanismo de inserción de trama, formación de calada y batida se diseñó utilizando la tecnología de prototipo virtual. Se puede reducir más del 25% de la vibración y ahorrar más del 5% de energía en comparación con los telares normales.",    // Español
                        "Water jet looms are designed for high-speed, low consumption and wide weaving range. Weft insertion, shedding and beating-up mechanism were designed by the technology of virtual prototype. More than 25% vibration can be reduced and more than 5% power can be saved than normal looms.",    // Inglés
                        "I telai a getto d'acqua sono progettati per alta velocità, basso consumo e un'ampia gamma di tessitura. Il meccanismo di inserimento della trama, apertura del passo e battitura è stato progettato utilizzando la tecnologia del prototipo virtuale. Più del 25% delle vibrazioni possono essere ridotte e più del 5% di energia può essere risparmiata rispetto ai telai normali.",    // Italiano
                        "O Tear RFJW10 é a evolução moderna dos modelos anteriores. Projetados para oferecer tecnologia avançada, velocidade, qualidade e eficiência ao mesmo tempo. Facilidade operacional com painel touch screen e novo software permitindo a troca de velocidade automática e versatilidade na produção de tecidos. RFJW10 é a melhor opção de tear com baixo consumo.",    // Portugués
                        "Les métiers à jet d'eau sont conçus pour une haute vitesse, une faible consommation et une large gamme de tissage. Le mécanisme d'insertion de trame, de formation de la foule et de battage a été conçu à l'aide de la technologie de prototype virtuel. Plus de 25% des vibrations peuvent être réduites et plus de 5% d'énergie peuvent être économisés par rapport aux métiers normaux.",    // Francés
                        "水喷织机旨在实现高速、低能耗和宽广的织造范围。纬纱插入、开口和打纬机制均采用虚拟样机技术设计。与普通织机相比，可以减少超过25%的振动，并节省超过5%的电力。",    // Chino

                    ],
                ],
                '2' => [
                    'name' => [
                        "Telares de lanzadera",    // Español
                        "Rapier Looms",    // Inglés
                        "Telai a Pinza",    // Italiano
                        "Tear de Pinças",    // Portugués
                        "Métiers à tisser à navette",    // Francés
                        "剑杆织机",    // Chino
                    ],
                    'description' => [
                        "Con el objetivo de aumentar el valor en la industria textil, para que los clientes puedan fabricar mejores productos de manera económica, RIFA ha desarrollado telares de lanzadera con ventajas únicas que incluyen alta eficiencia, diseño humanizado, sistema de batido fuerte, excelente estabilidad a alta velocidad y mucho más.\nCada modelo de esta serie garantiza una producción de tela de alta calidad y un menor consumo de energía.",    // Español
                        "With the aim to increase value in the textile industry, to have customer making better products economically, RIFA has developed weaving rapier loom with unique advantages including high efficiency, humanized design, strong beating system, excellent stability at high-speed, and much more.\nEach model of this series ensure a high-quality fabric production and lower power consumption.",    // Inglés
                        "Con l'obiettivo di aumentare il valore nell'industria tessile, affinché i clienti possano realizzare prodotti migliori in modo economico, RIFA ha sviluppato telai a navetta con vantaggi unici tra cui alta efficienza, design umanizzato, sistema di battitura robusto, eccellente stabilità ad alta velocità e molto altro.\nOgni modello di questa serie garantisce una produzione di tessuti di alta qualità e un consumo energetico inferiore.",    // Italiano
                        "Com o objetivo de aumentar o valor na indústria têxtil, para que o cliente possa produzir melhores produtos de forma econômica, a RIFA desenvolveu tear de lançadeiras com vantagens únicas, incluindo alta eficiência, design humanizado, sistema de batida forte, excelente estabilidade em alta velocidade e muito mais.\nCada modelo desta série garante uma produção de tecido de alta qualidade e menor consumo de energia.",    // Portugués
                        "Dans le but d'augmenter la valeur dans l'industrie textile, pour que le client puisse fabriquer de meilleurs produits économiquement, RIFA a développé des métiers à tisser à navette avec des avantages uniques, notamment une haute efficacité, un design humanisé, un système de battage puissant, une excellente stabilité à haute vitesse, et bien plus encore.\nChaque modèle de cette série garantit une production de tissu de haute qualité et une consommation d'énergie réduite.",    // Francés
                        "为了增加纺织行业的价值，使客户能够经济地生产出更好的产品，RIFA开发了具有独特优势的剑杆织机，包括高效率、人性化设计、强大的敲击系统、高速运行时的稳定性等等。\n该系列的每个型号都确保了高质量的织物生产和更低的能耗。",    // Chino
                    ],
                ],
                '3' => [
                    'name' => [
                        "Telares de rizo",    // Español
                        "Terry Looms",    // Inglés
                        "Telai a tela spugna",    // Italiano
                        "Tear de pinça para Felpa",    // Portugués
                        "Métiers à serviette",    // Francés
                        "梳棉织机",    // Chino
                    ],
                    'description' => [
                        "La serie RFTL tiene como objetivo tejer toallas de primera calidad. No solo puede tejer toallas comunes, sino también puede tejer bucles ascendentes y descendentes, bucles altos y bajos, patrones de pilas onduladas, bucles de cobertura únicos, rizo cortada, etc.\nRIFA desarrolló para establecer un nuevo referente en la tejeduría de rizo, con el objetivo de proporcionar al mercado una máquina de tejido que finalmente combine la máxima calidad y versatilidad con la eficiencia y facilidad de uso de la máquina.",    // Español
                        "RFTL series target is to weave top grade towels. Not only can weave common towels, but also can weave up and down loop, high and and low loop, wave pile patterns, single cover loop, cut pileterry, etc. \nRIFA developed to set a new benchmark in waving terry, with the aim to provide the market with a weaving machine which finally combines the most quality and versatility with efficiency and usability of the machine.",    // Inglés
                        "La serie RFTL si propone di tessere asciugamani di alta qualità. Non solo può tessere asciugamani comuni, ma può anche tessere trame a loop su e giù, loop alti e bassi, modelli di pila ondulata, loop di copertura singola, spugna tagliata, ecc.\nRIFA ha sviluppato per fissare un nuovo punto di riferimento nel tessere di spugna, con l'obiettivo di fornire al mercato una macchina tessile che finalmente combini la massima qualità e versatilità con l'efficienza e l'usabilità della macchina.",    // Italiano
                        "A série RFTL tem como alvo tecer toalhas de primeira qualidade. O RFTL80 foi desenvolvido para estabelecer referência em teares de felpa, com o objetivo de fornecer ao mercado uma máquina de tecelagem com a máxima qualidade, versatilidade e eficiência.",    // Portugués
                        "La série RFTL vise à tisser des serviettes de haute qualité. Elle peut non seulement tisser des serviettes ordinaires, mais aussi des boucles montantes et descendantes, des boucles hautes et basses, des motifs de pile ondulée, des boucles de couverture unique, de la bouclette coupée, etc.\nRIFA a développé pour établir une nouvelle norme dans le tissage éponge, dans le but de fournir au marché une machine à tisser qui combine enfin la qualité et la polyvalence maximales avec l'efficacité et l'utilité de la machine.",    // Francés
                        "RFTL系列的目标是织造高品质的毛巾。它不仅可以织造普通的毛巾，还可以织造上下环、高低环、波纹图案、单覆盖环、剪毛巾等。\nRIFA的目标是在梳棉织造方面设立新的基准，旨在为市场提供一款织机，最终将最高质量和多功能性与机器的效率和可用性结合起来。",    // Chino
                    ],
                ],
                '4' => [
                    'name' => [
                        "Telares de aire",    // Español
                        "Air Looms",    // Inglés
                        "Telai ad aria",    // Italiano
                        "Tear Jato de Ar",    // Portugués
                        "Métiers à air",    // Francés
                        "喷气织机",    // Chino


                    ],
                    'description' => [
                        "Como parte del objetivo de RIFA, la compañía suministra a los clientes máquinas de tejer de alta calidad y humanizadas ofreciendo ahorro de energía, operación fácil y aumento de la eficiencia.\nLa alta velocidad es una de las características más importantes de los telares a chorro de aire; la variación y el ruido se reducen mucho mediante el diseño de una línea de ubicación de urdimbre más razonable y la adición de un sistema de equilibrio de batida para cumplir con los requisitos de funcionamiento a alta velocidad.",    // Español
                        "As part of RIFA’s target, the company supplies customers high quality and humanized weaving machines by offering saving power, easy operation and increasing efficiency.\nHigh-speed is one of the most important characters of air jet looms; the variation and noise is much decreased through the designing of more reasonable warp location line and adding beating balance system to meet the requirement of high speed running.",    // Inglés
                        "Come parte dell'obiettivo di RIFA, l'azienda fornisce ai clienti macchine per tessere di alta qualità e umanizzate offrendo risparmio energetico, facilità d'uso e aumento dell'efficienza.\nL'alta velocità è una delle caratteristiche più importanti dei telai a getto d'aria; la variazione e il rumore sono molto ridotti grazie al design di una linea di posizionamento dell'ordito più ragionevole e all'aggiunta di un sistema di bilanciamento del battito per soddisfare i requisiti di funzionamento ad alta velocità.",    // Italiano
                        "Os teares RFJA30 jato de ar possuem desempenho avançado com sua estrutura reforçada que permite trabalhar com velocidade e eficiência tecidos de alta densidade. Equipado com um inverter que permite a troca de velocidade diretamente do tear e com o sistema de APR de ajuste automático de ruptura de fio de trama. Esse modelo é completamente automático pode atingir a velocidade de até 1.100 RPM.",    // Portugués
                        "Dans le cadre de l'objectif de RIFA, la société fournit aux clients des métiers à tisser de haute qualité et humanisés en offrant une économie d'énergie, une utilisation facile et une augmentation de l'efficacité.\nLa haute vitesse est l'une des caractéristiques les plus importantes des métiers à jet d'air ; la variation et le bruit sont fortement réduits grâce à la conception d'une ligne de localisation de chaîne plus raisonnable et à l'ajout d'un système d'équilibre de battage pour répondre aux exigences de fonctionnement à haute vitesse.",    // Francés
                        "作为RIFA目标的一部分，公司通过提供节能、易操作和提高效率的人性化织机，为客户提供高质量的人性化织机。\n高速是喷气织机最重要的特点之一；通过设计更合理的经纱位置线和添加打纬平衡系统，变异和噪音大大减少，以满足高速运行的要求。",    // Chino

                    ],
                ],
                //Electronic Jacquard
                '5' => [
                    'name' => [
                        "Jacquard Electrónico",
                        "Electronic Jacquard",
                        "Jacquard Elettronico",
                        "Jacquard Eletrônico",
                        "Jacquard Électronique",
                        "电子提花 (Diànzǐ tíhuā)",
                    ],
                    'description' => [
                        "Conozca nuestros jacquards electrónicos, diseñados para todo tipo de máquinas de tejido de chorro de aire, chorro de agua, lanzadera y proyectil. Estos jacquards son fáciles de adaptar y muy versátiles, ofreciendo una gama de productos completa y coordinada.\n Además, están disponibles con la función de red para transferir el diseño del patrón, asegurando una integración suave y eficiente en su proceso de producción.",
                        "Meet our electronic jacquards, designed for all types of air-jet, water-jet, shuttle and projectile weaving machines. These jacquards are easy to adapt and very versatile, offering a complete and coordinated product range.\n In addition, they are available with netting function to transfer the pattern design, ensuring a smooth and efficient integration into your production process.",
                        "Scopri i nostri jacquard elettronici, progettati per tutti i tipi di telai a getto d'aria, a getto d'acqua, a navetta e a proiettile. Questi jacquard sono facili da adattare e molto versatili, offrendo una gamma completa e coordinata di prodotti.\n Inoltre, sono disponibili con funzione di rete per trasferire il disegno del motivo, garantendo un'integrazione fluida ed efficiente nel tuo processo di produzione.",
                        "Conheça nossos jacquards eletrônicos, projetados para todos os tipos de máquinas de tecelagem a jato de ar, jato de água, pinça e projétil. Esses jacquards são fáceis de adaptar e muito versáteis, oferecendo uma gama completa e coordenada de produtos.\n Além disso, estão disponíveis com função de malha para transferir o design do padrão, garantindo uma integração suave e eficiente no seu processo de produção.",
                        "Découvrez nos jacquards électroniques, conçus pour tous types de métiers à tisser à jet d'air, à jet d'eau, à navette et à projectile. Ces jacquards sont faciles à adapter et très polyvalents, offrant une gamme de produits complète et coordonnée.\n De plus, ils sont disponibles avec une fonction de filetage pour transférer le design du motif, assurant une intégration fluide et efficace dans votre processus de production.",
                        "了解我们的电子提花机，适用于所有类型的喷气织机、水喷织机、梭织机和投射织机。这些提花机易于适应且非常灵活，提供了完整且协调的产品系列。\n 此外，它们配备了网状功能以传输图案设计，确保在您的生产过程中实现平稳高效的整合。"
                    ],
                ],
                '6' => [
                    'name' => [
                        "Máquina de urdido seccional",    // Español
                        "Sectional Warping Machine",    // Inglés
                        "Macchina di orditura sezionale",    // Italiano
                        "Urdideira Seccional",    // Portugués
                        "Machine d'ourdissage sectionnel",    // Francés
                        "分条整经机",    // Chino


                    ],
                    'description' => [
                        "Nuestras máquinas de urdido seccional están diseñadas para adaptarse a cualquier tipo de hilo, ofreciendo versatilidad y un rendimiento óptimo en cada aplicación. Desde los hilos más finos hasta los más gruesos, nuestro equipo garantiza una producción eficiente y de alta calidad.\nNuestro equipo de consultores de ventas está listo para ofrecer una cotización personalizada, brindando asesoramiento experto en la selección del plegador adecuado, la unidad de urdido óptima, el número de posiciones y más. Además, ofrecemos instalación y servicio postventa, asegurando una experiencia integral para nuestros clientes en cada paso del camino.",    // Español
                        "Our sectional warping machines are designed to adapt to any type of yarn, offering versatility and optimum performance in every application. From the finest to the coarsest yarn, our equipment guarantees efficient, high quality production.\nOur team of sales consultants is ready to offer a customized quotation, providing expert advice on the selection of the right creel, the optimal warping unit, the number of positions and more. In addition, we offer installation and after-sales service, ensuring a comprehensive experience for our customers every step of the way.",    // Inglés
                        "Le nostre macchine di orditura sezionale sono progettate per adattarsi a qualsiasi tipo di filato, offrendo versatilità e prestazioni ottimali in ogni applicazione. Dai filati più fini ai più grossi, il nostro equipaggiamento garantisce una produzione efficiente e di alta qualità.\nIl nostro team di consulenti di vendita è pronto a offrire un preventivo personalizzato, fornendo consulenza esperta sulla scelta del rocchetto giusto, dell'unità di orditura ottimale, del numero di posizioni e altro. Inoltre, offriamo installazione e assistenza post-vendita, garantendo un'esperienza completa per i nostri clienti in ogni fase del processo.",    // Italiano
                        "Nossas máquinas de urdimento seccional são projetadas para se adaptar a qualquer tipo de fio, oferecendo versatilidade e desempenho ideal em cada aplicação. Desde os fios mais finos aos mais grossos, nosso equipamento garante produção eficiente e de alta qualidade.\nNossa equipe de consultores de vendas está pronta para oferecer uma cotação personalizada, fornecendo consultoria especializada na seleção do creel correto, da unidade de urdimento ideal, do número de posições e muito mais. Além disso, oferecemos instalação e serviço pós-venda, garantindo uma experiência abrangente para nossos clientes em cada etapa do processo.",    // Portugués
                        "Nos machines d'ourdissage sectionnel sont conçues pour s'adapter à tout type de fil, offrant polyvalence et performance optimale dans chaque application. Des fils les plus fins aux plus gros, notre équipement garantit une production efficace et de haute qualité.\nNotre équipe de consultants en vente est prête à offrir un devis personnalisé, fournissant des conseils d'experts sur la sélection du bon ourdissoir, de l'unité d'ourdissage optimale, du nombre de positions et plus encore. De plus, nous proposons une installation et un service après-vente, garantissant une expérience complète pour nos clients à chaque étape.",    // Francés
                        "我们的分条整经机设计适应任何类型的纱线，在每个应用中都提供多功能性和最佳性能。从最细到最粗的纱线，我们的设备保证高效、高质量的生产。\n我们的销售顾问团队准备提供个性化报价，在选择合适的纱架、最佳整经单元、位置数量等方面提供专业建议。此外，我们提供安装和售后服务，确保我们的客户在每一步都能享受到全面的体验。",    // Chino
                    ],
                ],
                '7' => [
                    'name' => [
                        "Máquinas de urdido directo",    // Español
                        "Direct Warping Machines",    // Inglés
                        "Attrezzatura ideale per la preparazione pre-filatura.",    // Italiano
                        "Urdideira Direta",    // Portugués
                        "Machines d'ourdissage direct",    // Francés
                        "直接整经机",    // Chino
                    ],
                    'description' => [
                        "Nuestras máquinas de urdido directo son la elección perfecta para varios tipos de hilos cortados y son el equipo de preparación previo al hilado para varios tipos de telares sin lanzadera. Diseñadas para adaptarse a las necesidades específicas de cada cliente, nuestras máquinas garantizan un proceso de urdido óptimo y de alta calidad. Una máquina altamente eficiente que puede controlar la longitud y disposición del hilo de urdimbre.\nNuestro equipo de representantes de ventas está disponible para proporcionar una cotización personalizada, brindando asesoramiento experto sobre la selección del equipo adecuado y garantizando una integración perfecta en su proceso de producción. Además, ofrecemos servicios de instalación y soporte postventa, asegurando una experiencia completa y satisfactoria para nuestros clientes.",    // Español
                        "Our direct warping machines are the perfect choice for various types of chopped yarn and is the prespinning preparation equipment for various kinds of shuttleless looms. Designed to suit the specific needs of each customer, our machines guarantee an optimal and high quality warping process. A highly efficient machine that can control the length an arrangement of warp yarn.\nOur team of sales representatives is available to provide a customized quotation, giving expert advice on the selection of the right equipment and ensuring a seamless integration into your production process. In addition, we offer installation and after-sales support services, ensuring a complete and satisfactory experience for our customers.",    // Inglés
                        "Le nostre macchine di orditura diretta sono la scelta perfetta per vari tipi di filati tagliati e sono l'attrezzatura di preparazione pre-filatura per vari tipi di telai senza navetta. Progettate per soddisfare le esigenze specifiche di ciascun cliente, le nostre macchine garantiscono un processo di orditura ottimale e di alta qualità. Una macchina altamente efficiente che può controllare la lunghezza e la disposizione del filo di ordito.\nIl nostro team di rappresentanti di vendita è disponibile per fornire una quotazione personalizzata, offrendo consulenza esperta sulla selezione delle attrezzature giuste e garantendo un'integrazione perfetta nel processo produttivo. Inoltre, offriamo servizi di installazione e supporto post-vendita, garantendo un'esperienza completa e soddisfacente per i nostri clienti.",    // Italiano
                        "Nossas máquinas urdideiras direto são a escolha perfeita para vários tipos de fios cortados e são o equipamento de preparação pré-fiação para vários tipos de teares. Projetadas para atender às necessidades específicas de cada cliente, nossas máquinas garantem um processo de urdimento otimizado e de alta qualidade. Uma máquina altamente eficiente que pode controlar o comprimento e a disposição do fio de urdume.\nNossa equipe de representantes de vendas está disponível para fornecer uma cotação personalizada, oferecendo consultoria especializada na seleção do equipamento certo e garantindo uma integração perfeita ao seu processo de produção. Além disso, oferecemos serviços de instalação e suporte pós-venda, garantindo uma experiência completa e satisfatória para nossos clientes.",    // Portugués
                        "Nos machines d'ourdissage direct sont le choix parfait pour différents types de fils coupés et sont l'équipement de préparation à la filature pour divers types de métiers sans navette. Conçues pour répondre aux besoins spécifiques de chaque client, nos machines garantissent un processus d'ourdissage optimal et de haute qualité. Une machine très efficace qui peut contrôler la longueur et la disposition des fils de chaîne.\nNotre équipe de représentants commerciaux est disponible pour fournir un devis personnalisé, offrant des conseils d'experts sur le choix du bon équipement et garantissant une intégration transparente dans votre processus de production. De plus, nous offrons des services d'installation et de support après-vente, garantissant une expérience complète et satisfaisante pour nos clients.",    // Francés
                        "我们的直接整经机是各种类型切段纱线的理想选择，也是各种无梭织机的前纺准备设备。根据每个客户的具体需求设计，我们的机器保证了最佳和高质量的整经过程。这是一种高效的机器，可以控制经纱的长度和排列。\n我们的销售代表团队可以提供定制的报价，提供有关选择合适设备的专业建议，并确保无缝集成到您的生产过程中。此外，我们还提供安装和售后支持服务，确保为客户提供完整和满意的体验。",    // Chino
                    ],
                ],
                '8' => [
                    'name' => [
                        "Máquina de tejido de etiquetas",    // Español
                        "Label Weaving Machine",    // Inglés
                        "Macchina per tessitura di etichette",    // Italiano
                        "Máquina de tecelagem de etiquetas",    // Portugués
                        "Machine de tissage d'étiquettes",    // Francés
                        "标签织机",    // Chino


                    ],
                    'description' => [
                        "En ITG Group, nos complace presentar nuestra oferta de máquinas de tejido de etiquetas diseñadas para satisfacer las demandas más exigentes de la industria textil.\nNuestros telares ofrecen una combinación perfecta de velocidad, precisión y versatilidad, permitiendo a nuestros clientes producir etiquetas de calidad superior de manera eficiente y rentable.\nOfrecemos servicio de instalación y puesta en marcha para apoyar a nuestros clientes en cada paso del camino.",    // Español
                        "At ITG Group, we are pleased to introduce our offering of label weaving machine designed to meet the most stringent demands of the textile industry.\nOur looms offer a perfect combination of speed, precision and versatility, enabling our customers to produce superior quality labels efficiently and cost-effectively.\nWe offer installation and start-up service to support our customers every step of the way.",    // Inglés
                        "In ITG Group, siamo lieti di presentare la nostra offerta di macchine per tessitura di etichette progettate per soddisfare le esigenze più rigorose dell'industria tessile.\nI nostri telai offrono una combinazione perfetta di velocità, precisione e versatilità, consentendo ai nostri clienti di produrre etichette di qualità superiore in modo efficiente e conveniente.\nOffriamo un servizio di installazione e avviamento per supportare i nostri clienti in ogni fase del processo.",    // Italiano
                        "No ITG Group, temos o prazer de apresentar a nossa oferta de máquinas de tecelagem de etiquetas projetadas para atender às mais exigentes demandas da indústria têxtil.\nNossos teares oferecem uma combinação perfeita de velocidade, precisão e versatilidade, permitindo que nossos clientes produzam etiquetas de qualidade superior de forma eficiente e econômica.\nOferecemos serviço de instalação e inicialização para apoiar nossos clientes em cada etapa do caminho.",    // Portugués
                        "Chez ITG Group, nous sommes heureux de vous présenter notre offre de machine de tissage d'étiquettes conçue pour répondre aux exigences les plus strictes de l'industrie textile.\nNos métiers à tisser offrent une combinaison parfaite de vitesse, de précision et de polyvalence, permettant à nos clients de produire des étiquettes de qualité supérieure de manière efficace et rentable.\nNous offrons un service d'installation et de démarrage pour soutenir nos clients à chaque étape.",    // Francés
                        "在 ITG 集团，我们很高兴推出我们的标签织机，旨在满足纺织行业最严格的要求。\n我们的织机提供完美的速度、精度和多功能性组合，使我们的客户能够高效且经济地生产优质标签。\n我们提供安装和启动服务，以支持我们的客户在每一步。",    // Chino
                    ],
                ],
                '9' => [
                    'name' => [

                        "Telar jacquard de tela estrecha",    // Español
                        "Narrow Fabric Jacquard Loom",    // Inglés
                        "Telaio jacquard per tessuti stretti",    // Italiano
                        "Tear de Fica com Jacquard",    // Portugués
                        "Métier jacquard à bande étroite",    // Francés
                        "窄织物提花织机",    // Chino
                    ],
                    'description' => [
                        "Nuestra oferta de telares jacquard de tela estrecha es ideal para una amplia gama de aplicaciones como cintas elásticas y no elásticas, cintas redondas, cintas para sujetadores y correas.\nEstos avanzados telares combinan velocidad y precisión para producir productos de alta calidad. Además, ofrecemos un servicio completo de consultoría postventa asegurando que nuestros clientes maximicen su inversión.",    // Español
                        "Our offer of narrow fabric jacquard looms are ideal for a wide range of applications such as elastic and non-elastic tapes, round tapes, bra tapes and straps.\nThese advanced looms combine speed and precision to produce high quality products. In addition, we provide a complete after-sales consulting service ensuring that our customers maximize their investment.",    // Inglés
                        "La nostra offerta di telai jacquard per tessuti stretti è ideale per una vasta gamma di applicazioni come nastri elastici e non elastici, nastri rotondi, nastri per reggiseni e cinghie.\nQuesti avanzati telai combinano velocità e precisione per produrre prodotti di alta qualità. Inoltre, offriamo un servizio completo di consulenza post-vendita per garantire che i nostri clienti massimizzino il loro investimento.",    // Italiano
                        "Nossa oferta de teares jacquard de tecido estreito é ideal para uma ampla gama de aplicações, como fitas elásticas e não elásticas, fitas de sutiã e alças.\nEsses teares avançados combinam velocidade e precisão para produzir produtos de alta qualidade. Além disso, oferecemos um serviço completo de consultoria pós-venda, garantindo que nossos clientes maximizem seu investimento.",    // Portugués
                        "Notre offre de métiers jacquard pour bandes étroites est idéale pour une large gamme d'applications telles que les rubans élastiques et non élastiques, les rubans ronds, les rubans de soutien-gorge et les sangles.\nCes métiers avancés combinent vitesse et précision pour produire des produits de haute qualité. De plus, nous offrons un service complet de conseil après-vente, garantissant que nos clients maximisent leur investissement.",    // Francés
                        "我们的窄幅织物提花织机产品非常适合各种应用，例如弹性和非弹性带、圆带、胸罩带和肩带。\n这些先进的织机结合了速度和精度，可生产高质量的产品。此外，我们提供完整的售后咨询服务，确保我们的客户最大化他们的投资。",    // Chino

                    ],
                ],
                '10' => [
                    'name' => [
                        "Telar de agujas de alta velocidad",    // Español
                        "High-Speed Needle Loom",    // Inglés
                        "Telaio ad aghi ad alta velocità",    // Italiano
                        "Tear de agulhas de alta velocidade",    // Portugués
                        "Métier à aiguilles haute vitesse",    // Francés
                        "高速针织机",    // Chino
                    ],
                    'description' => [
                        "Nuestra oferta en telares de agujas de alta velocidad está diseñada para producir una variedad de productos de alta calidad, como tirantes de sujetadores, cintas, cremalleras y cinturones de seguridad, entre otros.\nNuestros telares combinan velocidad y precisión, garantizando una producción eficiente y confiable. Además, nuestro equipo de ventas está disponible para recomendar la máquina adecuada para las necesidades específicas de producción de cada cliente. También ofrecemos un servicio completo de consultoría postventa para asegurar que nuestros clientes aprovechen al máximo su equipo.",    // Español
                        "Our offer in high-speed needle looms are designed to produce a variety of high quality products, such as bra straps, ribbons, zippers and seat belts, among others.\nOur looms combine speed and precision, ensuring efficient and reliable production. In addition, our sales team is available to recommend the right machine for each customer's specific production needs. We also provide a complete after-sales consulting service to ensure that our customers get the most out of their equipment.",    // Inglés
                        "La nostra offerta di telai ad aghi ad alta velocità è progettata per produrre una varietà di prodotti di alta qualità, come spalline per reggiseni, nastri, cerniere e cinture di sicurezza, tra gli altri.\nI nostri telai combinano velocità e precisione, garantendo una produzione efficiente e affidabile. Inoltre, il nostro team di vendita è disponibile per consigliare la macchina giusta per le specifiche esigenze di produzione di ogni cliente. Offriamo anche un servizio completo di consulenza post-vendita per garantire che i nostri clienti ottengano il massimo dal loro equipaggiamento.",    // Italiano
                        "Nossa oferta em teares de agulhas de alta velocidade é projetada para produzir uma variedade de produtos de alta qualidade, como alças de sutiã, fitas, zíperes e cintos de segurança, entre outros.\nNossos teares combinam velocidade e precisão, garantindo uma produção eficiente e confiável. Além disso, nossa equipe de vendas está disponível para recomendar a máquina certa para as necessidades específicas de produção de cada cliente. Também oferecemos um serviço completo de consultoria pós-venda para garantir que nossos clientes obtenham o máximo de seu equipamento.",    // Portugués
                        "Notre offre de métiers à aiguilles haute vitesse est conçue pour produire une variété de produits de haute qualité, tels que des bretelles de soutien-gorge, des rubans, des fermetures éclair et des ceintures de sécurité, entre autres.\nNos métiers allient vitesse et précision, garantissant une production efficace et fiable. De plus, notre équipe commerciale est disponible pour recommander la machine adaptée aux besoins de production spécifiques de chaque client. Nous offrons également un service complet de conseil après-vente pour garantir que nos clients tirent le meilleur parti de leur équipement.",    // Francés
                        "我们的高速针织机产品旨在生产各种高质量的产品，如胸罩带、丝带、拉链和安全带等。\n我们的织机结合了速度和精度，确保高效和可靠的生产。此外，我们的销售团队随时可以为每个客户的特定生产需求推荐合适的机器。我们还提供完整的售后咨询服务，确保客户充分利用他们的设备。",    // Chino

                    ],
                ],

                '11' => [
                    'name' => [
                        "Máquina automática de crochet de alta velocidad",    // Español
                        "High-Speed Automatic Crochet Machine",    // Inglés
                        "Macchina automatica ad alta velocità per uncinetto",    // Italiano
                        "Máquina de crochê automática de alta velocidade",    // Portugués
                        "Machine automatique à crochet haute vitesse",    // Francés
                        "高速自动钩织机",    // Chino
                    ],
                    'description' => [
                        "Estas máquinas son herramientas ideales para fabricar cintas elásticas y no elásticas, utilizadas en una amplia gama de productos, desde prendas de vestir y cordones hasta artículos deportivos y mucho más. Con nuestras máquinas de crochet avanzadas, garantizamos una producción eficiente y precisa.\nAdemás, nuestro equipo de ventas está disponible para recomendar la máquina adecuada según las necesidades específicas de producción de cada cliente, y proporcionamos un servicio completo de consultoría posventa para garantizar el rendimiento máximo de su equipo.",    // Español
                        "These machines are ideal tools for manufacturing both elastic and non-elastic tapes, used in a wide range of products, from garments and shoelaces to sporting goods and much more. With our advanced crochet machines, we guarantee efficient and accurate production.\nIn addition, our sales team is available to recommend the right machine according to each customer's specific production needs, and we provide a complete after-sales consulting service to ensure maximum performance of your equipment.",    // Inglés
                        "Queste macchine sono strumenti ideali per la produzione di nastri elastici e non elastici, utilizzati in una vasta gamma di prodotti, dalle vestiario e lacci alle calzature sportive e molto altro ancora. Con le nostre macchine per uncinetto avanzate, garantiamo una produzione efficiente e precisa.\nInoltre, il nostro team di vendita è disponibile per consigliare la macchina giusta in base alle specifiche esigenze di produzione di ciascun cliente, e forniamo un servizio completo di consulenza post-vendita per garantire il massimo rendimento del suo equipaggiamento.",    // Italiano
                        "Essas máquinas são ferramentas ideais para a fabricação de fitas elásticas e não elásticas, usadas em uma ampla gama de produtos, desde roupas e cadarços até artigos esportivos e muito mais. Com nossas máquinas de crochê avançadas, garantimos uma produção eficiente e precisa.\nAlém disso, nossa equipe de vendas está disponível para recomendar a máquina certa de acordo com as necessidades específicas de produção de cada cliente, e fornecemos um serviço completo de consultoria pós-venda para garantir o desempenho máximo de seu equipamento.",    // Portugués
                        "Ces machines sont des outils idéaux pour la fabrication de rubans élastiques et non élastiques, utilisés dans une large gamme de produits, des vêtements et lacets aux articles de sport et bien plus encore. Avec nos machines à crochet avancées, nous garantissons une production efficace et précise.\nDe plus, notre équipe commerciale est disponible pour recommander la machine adaptée aux besoins spécifiques de production de chaque client, et nous fournissons un service complet de conseil après-vente pour garantir les performances maximales de votre équipement.",    // Francés
                        "这些机器是制造弹性和非弹性带的理想工具，可用于从服装和鞋带到体育用品等各种产品。借助我们先进的钩织机，我们确保高效准确的生产。\n此外，我们的销售团队可根据每位客户的具体生产需求推荐适合的机器，并提供完整的售后咨询服务，以确保您设备的最佳性能。",    // Chino
                    ],
                ],
                '12' => [
                    'name' => [
                        "Máquina cortadora y plegadora de etiquetas",
                        "Label & Folding machine",
                        "Macchina per etichettatura e piegatura",
                        "Máquinas de Corte e Dobra",
                        "Machine d'étiquetage et de pliage",
                        "标签和折叠机 (Biāoqiān hé zhédié jī)"
                    ],
                    'description' => [
                        "En ITG Group, ofrecemos una gama avanzada de máquinas para corte y plegado de etiquetas, diseñadas para garantizar alta precisión en cada operación.\n Nuestras máquinas multifuncionales son capaces de realizar varios tipos de cortes y pliegues, adaptándose a las necesidades específicas de cada cliente.Esta versatilidad y precisión garantizan un acabado perfecto de las etiquetas, optimizando la eficiencia y calidad en su producción.",
                        "At ITG Group, we offer an advanced range of label cutting and folding machines, designed to ensure high precision in every operation. \nOur multi-functional machines are capable of performing various types of cuts and folds, adapting to the specific needs of each customer. This versatility and accuracy guarantee a perfect label finish, optimizing efficiency and quality in your production.",
                        "In ITG Group, offriamo una gamma avanzata di macchine per il taglio e la piegatura delle etichette, progettate per garantire alta precisione in ogni operazione.\n Le nostre macchine multifunzionali sono in grado di eseguire vari tipi di tagli e piegature, adattandosi alle esigenze specifiche di ciascun cliente. Questa versatilità e precisione garantiscono una finitura perfetta delle etichette, ottimizzando l'efficienza e la qualità nella vostra produzione.",
                        "No ITG Group, oferecemos uma gama avançada de máquinas para corte e dobra de etiquetas, projetadas para garantir alta precisão em cada operação.\n Nossas máquinas multifuncionais são capazes de realizar vários tipos de cortes e dobras, adaptando-se às necessidades específicas de cada cliente.Essa versatilidade e precisão garantem um acabamento perfeito das etiquetas, otimizando a eficiência e a qualidade em sua produção.",
                        "Chez ITG Group, nous proposons une gamme avancée de machines pour le découpage et le pliage des étiquettes, conçues pour garantir une haute précision à chaque opération.\n Nos machines multifonctionnelles sont capables de réaliser divers types de découpes et de plis, s’adaptant aux besoins spécifiques de chaque client. Cette polyvalence et cette précision garantissent une finition parfaite des étiquettes, optimisant l'efficacité et la qualité de votre production.",
                        "在 ITG Group，我们提供一系列先进的标签切割和折叠机器，旨在确保每次操作的高精度。\n 我们的多功能机器能够执行各种类型的切割和折叠，适应每个客户的特定需求。 这种多样性和精确性保证了标签的完美完成，优化了生产中的效率和质量。"
                    ],
                ],
                '13' => [
                    'name' => [
                        "Ultrasónico",
                        "Ultrasonic",
                        "Ultrasonico",
                        "Máquina de Corte e Dobra Ultrassônica",
                        "Ultrasonique",
                        " 超声波的 (Chāoshēngbō de)"
                    ],
                    'description' => [
                        "Nuestras máquinas de corte y plegado ultrasónicas son la solución ideal para procesar etiquetas tejidas e impresas. Utilizando tecnología de corte ultrasónico, estas máquinas ofrecen un acabado limpio y preciso, eliminando los bordes irregulares y reduciendo significativamente el deshilachado.\n Este sistema innovador no solo mejora la calidad del producto final, sino que también aumenta la eficiencia y la velocidad de producción, garantizando resultados consistentes y de alta calidad en cada operación.",
                        "Our ultrasonic cutting and folding machines are the ideal solution for processing woven and printed labels. Using ultrasonic cutting technology, these machines offer a clean and precise finish, eliminating jagged edges and significantly reducing fraying. \n This innovative system not only improves the quality of the final product, but also increases efficiency and production speed, ensuring consistent, high quality results in every operation.",
                        "Le nostre macchine per il taglio e la piegatura ad ultrasuoni sono la soluzione ideale per il trattamento delle etichette tessute e stampate. Utilizzando la tecnologia di taglio ad ultrasuoni, queste macchine offrono una finitura pulita e precisa, eliminando gli spigoli frastagliati e riducendo significativamente lo sfilacciamento.\n Questo sistema innovativo non solo migliora la qualità del prodotto finale, ma aumenta anche l'efficienza e la velocità di produzione, garantendo risultati consistenti e di alta qualità in ogni operazione.",
                        "Nossas máquinas de corte e dobra ultrassônicas são a solução ideal para processar etiquetas tecidas e impressas. Utilizando tecnologia de corte ultrassônico, essas máquinas oferecem um acabamento limpo e preciso, eliminando bordas irregulares e reduzindo significativamente o desfiamento.\n Este sistema inovador não apenas melhora a qualidade do produto final, mas também aumenta a eficiência e a velocidade de produção, garantindo resultados consistentes e de alta qualidade em cada operação.",
                        "Nos machines de découpe et de pliage ultrasoniques sont la solution idéale pour le traitement des étiquettes tissées et imprimées. Utilisant la technologie de découpe ultrasonique, ces machines offrent une finition propre et précise, éliminant les bords dentelés et réduisant considérablement l'effilochage.\n Ce système innovant améliore non seulement la qualité du produit final, mais augmente également l'efficacité et la vitesse de production, garantissant des résultats cohérents et de haute qualité à chaque opération.",
                        "我们的超声波切割和折叠机是处理织物和印刷标签的理想解决方案。采用超声波切割技术，这些机器提供干净而精确的切割，消除了锯齿边缘，并显著减少了脱线现象。\n 这一创新系统不仅提高了最终产品的质量，还增加了生产效率和速度，确保每次操作的结果都具有一致性和高质量。",
                    ],
                ],

                '14' => [
                    'name' => [
                        "Punto sencillo",
                        "Single jersey",
                        "Jersey singolo",
                        "Máquina Mono",
                        "Jersey simple",
                        "单面针织 (Dānmiàn zhēnzhī)"
                    ],
                    'description' => [
                        "Descubre nuestra oferta excepcional de telar circular de punto sencillo, diseñado para una amplia variedad de aplicaciones, incluyendo camisetas, ropa deportiva, trajes de baño y ropa de aeróbic.\n Estos telares ofrecen una precisión y calidad inigualables, garantizando resultados óptimos para cada tipo de prenda. Además, proporcionamos asesoramiento técnico experto para asegurar que elijas la máquina adecuada para tus necesidades de producción.\n Para más información y asistencia personalizada, por favor contacta a tu representante de ventas.",
                        "Discover our exceptional offering of single jersey circular looms designed for a wide variety of applications, including t-shirts, sportswear, swimwear and aerobic wear. \n These looms offer unmatched precision and quality, ensuring optimal results for every type of garment. In addition, we provide expert technical advice to ensure that you choose the right machine for your production needs. \n For more information and personalized assistance, please contact your sales representative.",
                        "Scopri la nostra offerta eccezionale di telai circolari a maglia semplice, progettati per una vasta gamma di applicazioni, inclusi t-shirt, abbigliamento sportivo, costumi da bagno e abbigliamento per aerobica. \n Questi telai offrono una precisione e qualità senza pari, garantendo risultati ottimali per ogni tipo di capo. Inoltre, forniamo consulenza tecnica esperta per assicurarti di scegliere la macchina giusta per le tue esigenze di produzione. \n Per ulteriori informazioni e assistenza personalizzata, contatta il tuo rappresentante commerciale.",
                        "Descubra nossa oferta excepcional de teares circulares de Máquina Mono, projetados para uma ampla variedade de aplicações, incluindo camisetas, roupas esportivas, trajes de banho e roupas para aeróbica. \n Esses teares oferecem precisão e qualidade incomparáveis, garantindo resultados ótimos para cada tipo de vestuário. Além disso, oferecemos consultoria técnica especializada para garantir que você escolha a máquina certa para suas necessidades de produção. \n Para mais informações e assistência personalizada, entre em contato com seu representante de vendas.",
                        "Découvrez notre offre exceptionnelle de métiers à tricoter circulaires en jersey simple, conçus pour une grande variété d'applications, y compris les t-shirts, les vêtements de sport, les maillots de bain et les vêtements d'aérobic.\n Ces métiers offrent une précision et une qualité inégalées, garantissant des résultats optimaux pour chaque type de vêtement. De plus, nous fournissons des conseils techniques experts pour vous assurer de choisir la machine adaptée à vos besoins de production. \n Pour plus d'informations et une assistance personnalisée, veuillez contacter votre représentant commercial.",
                        "发现我们卓越的单面针织圆形织机，适用于各种应用，包括T恤、运动服、泳装和健美操服。\n 这些织机提供无与伦比的精度和质量，确保每种类型的服装都能获得最佳效果。此外，我们提供专业的技术建议，以确保您选择适合生产需求的机器。\n 欲了解更多信息和个性化服务，请联系您的销售代表。",
                    ],
                ],

                '15' => [
                    'name' => [
                        "Interlock/Rib",
                        "Interlock/Rib",
                        "Interlock/Rib",
                        "Interlock/RIBANA",
                        "Interlock/Rib",
                        "Interlock/Rib",
                    ],
                    'description' => [
                        "Explora nuestra avanzada gama de telar circular Interlock/Rib, ideal para producir tejidos Rib, interlock y estructurados de 8 cierres. Estos telares garantizan una precisión y calidad superior para tus tejidos especializados.\n El sistema de limpieza de doble cilindro, con ventiladores de limpieza en el dial de agujas superior y en el cilindro inferior, limpia el polvo de algodón de manera más efectiva, previniendo la rotura de agujas y mejorando la calidad del tejido. Además, ofrecemos asesoramiento técnico experto para asegurar que selecciones la máquina perfecta para tus necesidades de producción. Para más información y asistencia personalizada, por favor contacta a tu representante de ventas.",
                        "Explore our advanced offering of Interlock/Rib circular looms, ideal for producing Rib, interlock and structured 8-lock fabrics. These looms ensure superior precision and quality for your specialty fabrics.\n The double cylinder dusting system, with dusting fans on the upper needle dial and lower cylinder, cleans cotton dust more effectively, preventing needle breakage and improving fabric quality.\nIn addition, we offer expert technical advice to ensure that you select the perfect machine for your production needs. For more information and personalized assistance, please contact your sales representative.",
                        "Esplora la nostra avanzata gamma di telai circolari Interlock/Rib, ideali per produrre tessuti Rib, interlock e strutturati a 8 chiusure. Questi telai garantiscono una precisione e una qualità superiori per i tuoi tessuti specializzati. Il sistema di pulizia a doppio cilindro, con ventilatori di pulizia sul dial delle aghi superiore e sul cilindro inferiore, pulisce il polvere di cotone in modo più efficace, prevenendo la rottura degli aghi e migliorando la qualità del tessuto. Inoltre, offriamo consulenza tecnica esperta per garantire che tu scelga la macchina perfetta per le tue esigenze di produzione. Per ulteriori informazioni e assistenza personalizzata, contatta il tuo rappresentante commerciale.",
                        " Explore nossa avançada oferta de tear circular Interlock/ana, ideal para produzir tecidos ana, interlock e estruturados com 8 fechos. Estes teares garantem precisão e qualidade superiores para seus tecidos especializados. O sistema de limpeza de cilindro duplo, com ventiladores de limpeza no disco de agulhas superior e no cilindro inferior, limpa o pó de algodão de forma mais eficaz, prevenindo a quebra de agulhas e melhorando a qualidade do tecido. Além disso, oferecemos aconselhamento técnico especializado para garantir que você escolha a máquina perfeita para suas necessidades de produção. Para mais informações e assistência personalizada, entre em contato com seu representante de vendas.",
                        "Découvrez notre gamme avancée de métiers à tisser circulaires Interlock/Rib, idéaux pour produire des tissus Rib, interlock et structurés à 8 fermetures. Ces métiers garantissent une précision et une qualité supérieures pour vos tissus spécialisés. Le système de nettoyage à double cylindre, avec des ventilateurs de nettoyage sur le cadran d'aiguilles supérieur et le cylindre inférieur, nettoie la poussière de coton plus efficacement, prévenant la casse des aiguilles et améliorant la qualité du tissu. De plus, nous offrons des conseils techniques spécialisés pour garantir que vous sélectionniez la machine parfaite pour vos besoins de production. Pour plus d'informations et une assistance personnalisée, veuillez contacter votre représentant commercial.",
                        "探索我们先进的Interlock/Rib圆织机系列，适用于生产Rib、interlock和结构性8锁面料。这些织机确保了您的专业面料的卓越精度和质量。 双缸清灰系统配备了上针盘和下缸上的清灰风扇，更有效地清除棉尘，防止针断裂，提高面料质量。 此外，我们提供专业的技术咨询，确保您选择适合您生产需求的完美机器。有关更多信息和个性化协助，请联系您的销售代表。"
                    ],
                ],


                '16' => [
                    'name' => [
                        "Single computerized",
                        "Single computerized",
                        "Single computerized",
                        "Jacquard Mono",
                        "Single computerized",
                        "Single computerized",
                    ],
                    'description' => [
                        "Explora nuestra oferta de telares circulares Jacquard, de Malla y de Felpa con computadora, ideales para aplicaciones como prendas de moda y ropa interior. A diferencia de las máquinas jacquard comunes, estos telares utilizan selectores computarizados para seleccionar agujas en el cilindro con la técnica de tejido de 3 vías, recogido y salto, lo que te permite producir tejidos con diferentes patrones sin limitaciones.\nEsta característica también ahorra tiempo al cambiar patrones. Además, ofrecemos asesoramiento técnico experto para garantizar que selecciones la máquina perfecta para tus necesidades de producción.\nPara más información y asistencia personalizada, por favor, contacta a tu representante de ventas.",
                        " Explore our offer of Single Computerized Jacquard, Mesh and Terry circular looms, ideal for applications such as fashion garments and underwear. Unlike common jacquard machines, these looms use computerized selectors to select needles on the cylinder with the 3-way knit, pick and skip technique, allowing you to produce fabrics with different patterns without limitations.\nThis feature also saves time when changing patterns. In addition, we offer expert technical advice to ensure that you select the perfect machine for your production needs.\nFor more information and personalized assistance, please contact your sales representative.",
                        "Esplora la nostra offerta di telai circolari Jacquard, a rete e in spugna con computer, ideali per applicazioni come abbigliamento alla moda e biancheria intima. A differenza delle macchine jacquard comuni, questi telai utilizzano selettori computerizzati per selezionare aghi nel cilindro con la tecnica di maglieria a 3 vie, prelievo e salto, permettendoti di produrre tessuti con diversi motivi senza limitazioni.\nQuesta caratteristica consente anche di risparmiare tempo durante il cambiamento dei motivi. Inoltre, offriamo consulenza tecnica esperta per garantire che tu scelga la macchina perfetta per le tue esigenze produttive.\nPer ulteriori informazioni e assistenza personalizzata, ti preghiamo di contattare il tuo rappresentante commerciale.",
                        "Explore nossa oferta de teares circulares Jacquard, de Malha e de Felpa com computador, ideais para aplicações como roupas de moda e lingerie. Ao contrário das máquinas jacquard comuns, esses teares utilizam seletores computadorizados para selecionar agulhas no cilindro com a técnica de malharia de 3 vias, permitindo que você produza tecidos com diferentes padrões sem limitações.\nEssa característica também economiza tempo ao trocar padrões. Além disso, oferecemos consultoria técnica especializada para garantir que você escolha a máquina perfeita para suas necessidades de produção.\nPara mais informações e assistência personalizada, entre em contato com seu representante de vendas.",
                        "Découvrez notre offre de métiers à tisser circulaires Jacquard, en maille et en éponge informatisés, idéaux pour des applications telles que les vêtements de mode et les sous-vêtements. Contrairement aux machines jacquard classiques, ces métiers utilisent des sélecteurs informatisés pour sélectionner les aiguilles dans le cylindre avec la technique de tricot à 3 voies, sélection et saut, vous permettant de produire des tissus avec différents motifs sans limitations.\nCette fonctionnalité permet également de gagner du temps lors du changement de motifs. De plus, nous offrons des conseils techniques spécialisés pour garantir que vous sélectionnez la machine parfaite pour vos besoins de production.\nPour plus d'informations et une assistance personnalisée, veuillez contacter votre représentant commercial.",
                        "探索我们的单面计算机化提花、网状和毛巾圆形织机，适用于时尚服装和内衣等应用。与普通提花机不同，这些织机使用计算机化选择器通过3路编织、挑选和跳跃技术选择缸上的针，使您能够生产具有不同图案的面料而没有限制。\n此功能还可以在更换图案时节省时间。此外，我们提供专业的技术建议，以确保您选择适合您生产需求的完美机器。\n有关更多信息和个性化帮助，请联系您的销售代表。",
                    ],
                ],

                '17' => [
                    'name' => [
                        "Double computerized",
                        "Double computerized",
                        "Double computerized",
                        "Double computerized",
                        "Double computerized",
                        "Double computerized",
                    ],
                    'description' => [
                        "Ofrecemos telar circular jacquard con transferencia doble computarizada, de dial y cilindro, ideales para aplicaciones en ropa, ropa de cama, almohadas, toallas, tejidos para niños y otros textiles para el hogar. Cualquier patrón de tela intrincado puede ser convertido a través del sistema de preparación de patrones computarizado en un comando especial que instruye a los selectores para crear tejido jacquard.\nEstos telares garantizan una precisión y calidad excepcionales para sus textiles. Además, ofrecemos asesoramiento técnico experto para asegurar que seleccione la máquina perfecta para sus necesidades de producción.\nPara obtener más información y asistencia personalizada, por favor, contacte a su representante de ventas.",
                        "We offer double computerized transfer, dial & cylinder jacquard circular looms, ideal for applications in apparel, bedding, pillows, towels, children's fabrics and other home textiles. Any intricate fabric pattern can be converted through the computerized pattern preparation system into a special command that instructs the selectors to create jacquard fabric.\nThese looms guarantee exceptional accuracy and quality for your textiles. In addition, we offer expert technical advice to ensure that you select the perfect machine for your production needs.\nFor more information and personalized assistance, please contact your sales representative.",
                        "Offriamo telai circolari jacquard con trasferimento doppio computerizzato, con disco e cilindro, ideali per applicazioni in abbigliamento, biancheria da letto, cuscini, asciugamani, tessuti per bambini e altri tessuti per la casa. Qualsiasi motivo di tessuto intricato può essere convertito tramite il sistema di preparazione dei motivi computerizzato in un comando speciale che istruisce i selettori per creare tessuto jacquard.\nQuesti telai garantiscono un'eccezionale precisione e qualità per i tuoi tessuti. Inoltre, offriamo consulenza tecnica esperta per garantire che tu scelga la macchina perfetta per le tue esigenze produttive.\nPer ulteriori informazioni e assistenza personalizzata, ti preghiamo di contattare il tuo rappresentante commerciale.",
                        "Oferecemos tear circular jacquard com transferência dupla computadorizada, com disco e cilindro, ideais para aplicações em vestuário, roupas de cama, almofadas, toalhas, tecidos infantis e outros têxteis para o lar. Qualquer padrão de tecido intrincado pode ser convertido através do sistema de preparação de padrões computadorizado em um comando especial que instrui os seletores a criar tecido jacquard.\nEsses teares garantem precisão e qualidade excepcionais para seus têxteis. Além disso, oferecemos consultoria técnica especializada para garantir que você escolha a máquina perfeita para suas necessidades de produção.\nPara mais informações e assistência personalizada, entre em contato com seu representante de vendas.",
                        "Nous proposons des métiers à tisser circulaires jacquard avec transfert double informatisé, avec cadran et cylindre, idéaux pour les applications en habillement, linge de lit, oreillers, serviettes, tissus pour enfants et autres textiles pour la maison. Tout motif de tissu complexe peut être converti via le système de préparation des motifs informatisé en une commande spéciale qui indique aux sélecteurs de créer du tissu jacquard.\nCes métiers garantissent une précision et une qualité exceptionnelles pour vos textiles. De plus, nous offrons des conseils techniques spécialisés pour vous assurer de sélectionner la machine parfaite pour vos besoins de production.\nPour plus d'informations et une assistance personnalisée, veuillez contacter votre représentant commercial.",
                        "我们提供双重计算机化转移、盘针和缸针的圆形提花织机，适用于服装、床上用品、枕头、毛巾、儿童面料及其他家用纺织品。任何复杂的面料图案都可以通过计算机图案准备系统转换为特殊指令，指示选择器制作提花面料。\n这些织机保证了您纺织品的卓越精度和质量。此外，我们还提供专业技术建议，以确保您选择适合您生产需求的完美机器。\n有关更多信息和个性化帮助，请联系您的销售代表。"
                    ],
                ],

                '18' => [
                    'name' => [
                        "Máquina de calcetines",
                        "Sock machine",
                        "Macchina per calze",
                        " Máquina de meias",
                        "Machine à chaussettes",
                        " 织袜机 (Zhī wà jī)"

                    ],
                    'description' => [
                        "Explore nuestra serie GG de máquinas de tejer calcetines, que incluye diferentes modelos ideales para la producción de calcetines invisibles, calcetines planos, calcetines de felpa, calcetines de doble felpa y más. Contamos con una variedad de equipos, incluidos máquinas totalmente informatizadas, máquinas de coser inteligentes automáticas y sistemas automáticos de unión de puntas. Cada modelo está diseñado para ofrecer eficiencia y alta calidad en la producción de calcetines, adaptándose a diversas necesidades y especificaciones de fabricación.\nNuestro equipo de representantes de ventas está disponible para proporcionar una cotización personalizada, brindando asesoramiento experto en la selección del equipo adecuado y garantizando una integración fluida en su proceso de producción.",
                        "Explore our GG series of sock knitting machines, which includes different models ideal for the production of invisible socks, flat socks, terry socks, double terry socks and more. We have a variety of equipment, including fully computerized machines, automatic intelligent sewing machines and automatic toe linking systems. Each model is designed to offer efficiency and high quality in sock production, adapting to various manufacturing needs and specifications.\nOur team of sales representatives is available to provide a customized quotation, giving expert advice on the selection of the right equipment and ensuring a seamless integration into your production process.",
                        "Esplora la nostra serie GG di macchine per la produzione di calze, che include diversi modelli ideali per la produzione di calzini invisibili, calzini piatti, calzini in spugna, calzini in doppia spugna e altro. Abbiamo una varietà di attrezzature, comprese macchine completamente informatizzate, macchine da cucire intelligenti automatiche e sistemi automatici di collegamento delle punte. Ogni modello è progettato per offrire efficienza e alta qualità nella produzione di calze, adattandosi a diverse esigenze e specifiche di produzione.\nIl nostro team di rappresentanti commerciali è disponibile per fornire un preventivo personalizzato, offrendo consulenza esperta nella selezione dell'attrezzatura giusta e garantendo un'integrazione senza problemi nel processo di produzione.",
                        "Explore nossa série GG de máquinas de tricô para meias, que inclui diferentes modelos ideais para a produção de meias invisíveis, meias lisas, meias de felpa, meias de felpa dupla e muito mais. Temos uma variedade de equipamentos, incluindo máquinas totalmente computadorizadas, máquinas de costura inteligentes automáticas e sistemas automáticos de ligação de pontas. Cada modelo é projetado para oferecer eficiência e alta qualidade na produção de meias, adaptando-se a várias necessidades e especificações de fabricação.\nNossa equipe de representantes de vendas está disponível para fornecer uma cotação personalizada, oferecendo consultoria especializada na seleção do equipamento certo e garantindo uma integração perfeita ao seu processo de produção.",
                        "Explorez notre série GG de machines à tricoter des chaussettes, qui comprend différents modèles idéaux pour la production de chaussettes invisibles, chaussettes plates, chaussettes en éponge, chaussettes en double éponge et plus encore. Nous disposons d'une variété d'équipements, y compris des machines entièrement informatisées, des machines à coudre intelligentes automatiques et des systèmes automatiques de liaison des pointes. Chaque modèle est conçu pour offrir efficacité et haute qualité dans la production de chaussettes, en s'adaptant à divers besoins et spécifications de fabrication.\nNotre équipe de représentants commerciaux est disponible pour fournir un devis personnalisé, en offrant des conseils d'experts sur le choix du bon équipement et en garantissant une intégration fluide dans votre processus de production.",
                        "探索我们的 GG 系列袜子编织机，其中包括适合生产隐形袜、平袜、毛巾袜、双层毛巾袜等的不同型号。我们拥有各种设备，包括全自动计算机控制的机器、自动智能缝纫机和自动脚趾连接系统。每种型号都旨在在袜子生产中提供高效和高质量，并适应各种制造需求和规格。\n我们的销售代表团队随时为您提供定制报价，提供专业建议，以选择合适的设备，并确保在您的生产过程中无缝集成"
                    ],
                ],

                '19' => [
                    'name' => [
                        "Máquinas trenzadoras",
                        "Braiding machines",
                        "Macchine per intrecciare",
                        "Máquinas de Cordão",
                        "Machines à tresser",
                        " 编织机 (Biānzhī jī)"
                    ],
                    'description' => [
                        "Ofrecemos una amplia variedad de máquinas de trenzado, capaces de producir una vasta gama de aplicaciones como cuerdas, cordones, cintas, cables, hilos, material médico, mangueras, tubos de PVC y más. Nuestras máquinas están diseñadas para satisfacer diversas necesidades de producción con eficiencia y precisión.\nAdemás, proporcionamos diferentes máquinas para complementar su producción, como máquinas de bobinado y de acabado, así como repuestos para garantizar que esté completamente equipado. Recomendamos proporcionar al vendedor una muestra o una idea clara de lo que desea producir, para que podamos ofrecer la mejor recomendación sobre el modelo de máquina más adecuado para sus requisitos específicos.",
                        "We offer a wide variety of braiding machines, capable of producing a vast range of applications such as ropes, shoelaces, ribbons, cabling, floss, medical material, hose, PVC tubes, and more. Our machines are designed to meet various production needs with efficiency and precision.\nIn addition, we provide different machines to complement your production, such as winding and tipping machines, so as spare parts to ensure that you are fully equipped. We recommend providing the salesperson with a sample or a clear idea of what you want to produce, so that we can offer the best recommendation on the most suitable machine model for your specific requirements.",
                        "Offriamo una vasta gamma di macchine per intrecciatura, in grado di produrre una vasta gamma di applicazioni come corde, lacci, nastri, cavi, fili, materiale medico, tubi, tubi in PVC e altro ancora. Le nostre macchine sono progettate per soddisfare varie esigenze di produzione con efficienza e precisione.\nInoltre, forniamo macchine diverse per completare la tua produzione, come macchine per avvolgimento e di finitura, oltre ai pezzi di ricambio per garantire che tu sia completamente equipaggiato. Ti consigliamo di fornire al venditore un campione o un'idea chiara di ciò che desideri produrre, in modo che possiamo offrirti la migliore raccomandazione sul modello di macchina più adatto alle tue esigenze specifiche.",
                        "Oferecemos uma ampla variedade de máquinas de trançamento, capazes de produzir uma vasta gama de aplicações, como cordas, cadarços, fitas, cabos, fios, material médico, mangueiras, tubos de PVC e muito mais. Nossas máquinas são projetadas para atender a diversas necessidades de produção com eficiência e precisão.\nAlém disso, fornecemos diferentes máquinas para complementar sua produção, como Espulgadeiras e Ponteadeiras, assim como peças de reposição para garantir que você esteja totalmente equipado. Recomendamos fornecer ao vendedor uma amostra ou uma ideia clara do que você deseja produzir, para que possamos oferecer a melhor recomendação sobre o modelo de máquina mais adequado para suas necessidades específicas.",
                        "Nous proposons une large gamme de machines à tresser, capables de produire une vaste gamme d'applications telles que cordes, lacets, rubans, câbles, fils, matériel médical, tuyaux, tubes en PVC et plus encore. Nos machines sont conçues pour répondre à divers besoins de production avec efficacité et précision.\nDe plus, nous fournissons différentes machines pour compléter votre production, telles que des machines d'enroulement et de finition, ainsi que des pièces de rechange pour garantir que vous soyez entièrement équipé. Nous recommandons de fournir au vendeur un échantillon ou une idée claire de ce que vous souhaitez produire, afin que nous puissions offrir la meilleure recommandation sur le modèle de machine le plus adapté à vos besoins spécifiques.",
                        "我们提供各种编织机，能够生产广泛的应用，如绳索、鞋带、缎带、电缆、线绳、医疗材料、软管、PVC管等。我们的机器旨在以高效和精确的方式满足各种生产需求。此外，我们还提供不同的机器来补充您的生产需求，如绕线机和定型机，以及备用零件，确保您完全装备好。我们建议您向销售人员提供样品或清晰的生产意图，以便我们能够提供最适合您特定要求的机器型号的最佳建议。",
                    ],
                ],

                '20' => [
                    'name' => [
                        "Máquinas punteadoras",
                        "Tipping machines",
                        "Macchine per rifinitura",
                        "Ponteadeiras",
                        "Machines à embouts",
                        "封头机 (Fēng tóu jī)"

                    ],
                    'description' => [
                        "Como parte de nuestra oferta en máquinas de trenzado, también proporcionamos diferentes máquinas, como máquinas de acabado automáticas y semiautomáticas, diseñadas específicamente para fijar acetato en los extremos de las cuerdas, como las utilizadas en cordones de zapatos y asas de bolsas. Estas máquinas son capaces de manejar diferentes longitudes de cuerda, brindando versatilidad y precisión en la producción. Además, para complementar su proceso de fabricación, también suministramos acetato de alta calidad, asegurando que nuestros clientes dispongan de todos los materiales necesarios para una producción eficiente y constante.",
                        " As part of our offer in braiding machines, we also provide different machines such as both automatic and semi-automatic tipping machines, designed specifically for attaching acetate to the ends of ropes, such as those used in shoelaces and bag handles.\nThese machines are capable of handling different rope lengths, providing versatility and precision in production. In addition, to complement your manufacturing process, we also supply high quality acetate, ensuring that our customers have all the materials necessary for efficient and consistent production.",
                        "Come parte della nostra offerta di macchine per intrecciare, forniamo anche diverse macchine, come macchine automatiche e semiautomatiche per l'applicazione di acetato, progettate specificamente per attaccare l'acetato alle estremità delle corde, come quelle utilizzate nei lacci delle scarpe e nelle maniglie delle borse. Queste macchine sono in grado di gestire diverse lunghezze di corda, offrendo versatilità e precisione nella produzione. Inoltre, per completare il tuo processo di produzione, forniamo anche acetato di alta qualità, assicurando che i nostri clienti dispongano di tutti i materiali necessari per una produzione efficiente e costante.",
                        "Como parte de nossa oferta em máquinas de trançar, também fornecemos diferentes máquinas, como máquinas automáticas e semiautomáticas para aplicação de acetato, projetadas especificamente para fixar acetato nas extremidades das cordas, como as usadas em cadarços e alças de bolsas. Essas máquinas são capazes de manusear diferentes comprimentos de corda, proporcionando versatilidade e precisão na produção. Além disso, para complementar o seu processo de fabricação, também fornecemos acetato de alta qualidade, garantindo que nossos clientes tenham todos os materiais necessários para uma produção eficiente e consistente.",
                        "Dans le cadre de notre offre en machines à tresser, nous fournissons également différentes machines, telles que des machines à emboutir automatiques et semi-automatiques, conçues spécifiquement pour fixer l'acétate aux extrémités des cordes, comme celles utilisées dans les lacets et les poignées de sacs. Ces machines sont capables de gérer différentes longueurs de corde, offrant polyvalence et précision dans la production. De plus, pour compléter votre processus de fabrication, nous fournissons également de l'acétate de haute qualité, garantissant que nos clients disposent de tous les matériaux nécessaires pour une production efficace et constante.",
                        "作为我们编织机产品的一部分，我们还提供不同类型的机器，例如自动和半自动的打尖机，专为将醋酸纤维附在绳索末端（如鞋带和包袋手柄）而设计。这些机器能够处理不同长度的绳索，在生产中提供多样性和精确度。此外，为了补充您的生产过程，我们还供应高质量的醋酸纤维，确保我们的客户拥有所有必要的材料，以实现高效和一致的生产。"
                    ],
                ],

                '21' => [
                    'name' => [
                        "Máquinas de bobinado",
                        "Winding machines",
                        "Macchine avvolgitrici",
                        "Espuladeiras",
                        "Machines à enrouler",
                        "卷绕机 (Juǎnrào jī)"

                    ],
                    'description' => [
                        "Nuestras máquinas de bobinado son el complemento ideal para tu línea de producción de trenzado. Estas máquinas se encargan de llenar las bobinas con hilos, listas para ser utilizadas en las máquinas de trenzado. Disponemos de una variedad de modelos para adaptarnos a tus necesidades específicas. Con nuestras bobinadoras, obtienes eficiencia y facilidad de uso, garantizando una producción continua y de alta calidad. Además, para complementar tu proceso de fabricación, también suministramos diferentes tipos de hilos de la mejor calidad y resistencia para alimentar tus bobinadoras, asegurando que nuestros clientes tengan todos los materiales necesarios para una producción eficiente y consistente.",
                        "Our winding machines are the ideal complement to your braiding production line. These machines are in charge of filling the bobbins with yarns, ready to be used in the braiding machines. We have a variety of models to suit your specific needs. With our winders, you get efficiency and ease of use, ensuring continuous, high-quality production.\nIn addition, to complement your manufacturing process, we also supply different types of yarns of the best quality and resistance so that you can feed your winders, ensuring that our customers have all the materials necessary for efficient and consistent production.",
                        "Le nostre macchine per avvolgimento sono il complemento ideale per la tua linea di produzione di intrecci. Queste macchine si occupano di riempire le bobine con fili, pronte per essere utilizzate nelle macchine per intrecciare. Abbiamo una varietà di modelli per adattarci alle tue esigenze specifiche. Con i nostri avvolgitori, ottieni efficienza e facilità d'uso, garantendo una produzione continua e di alta qualità. Inoltre, per completare il tuo processo di produzione, forniamo anche diversi tipi di fili della migliore qualità e resistenza per alimentare i tuoi avvolgitori, assicurando che i nostri clienti abbiano tutti i materiali necessari per una produzione efficiente e costante.",
                        "Nossas Espuladeiras são o complemento ideal para sua linha de produção de trançamento. Essas máquinas são responsáveis por encher as bobinas com fios, prontas para serem usadas nas máquinas de trançar. Temos uma variedade de modelos para atender às suas necessidades específicas. Com Nossas espuladeiras, você obtém eficiência e facilidade de uso, garantindo uma produção contínua e de alta qualidade. Além disso, para complementar seu processo de fabricação, também fornecemos diferentes tipos de fios da melhor qualidade e resistência para alimentar seus bobinadores, garantindo que nossos clientes tenham todos os materiais necessários para uma produção eficiente e consistente.",
                        "Nos machines à enrouler sont le complément idéal de votre ligne de production de tressage. Ces machines sont responsables du remplissage des bobines avec des fils, prêtes à être utilisées dans les machines à tresser. Nous avons une variété de modèles pour répondre à vos besoins spécifiques. Avec nos enrouleurs, vous bénéficiez d'une efficacité et d'une facilité d'utilisation, garantissant une production continue et de haute qualité. De plus, pour compléter votre processus de fabrication, nous fournissons également différents types de fils de la meilleure qualité et résistance pour alimenter vos enrouleurs, assurant que nos clients disposent de tous les matériaux nécessaires pour une production efficace et constante.",
                        "我们的绕线机是您编织生产线的理想补充。这些机器负责将纱线填充到线轴上，准备好用于编织机。我们提供各种型号，以满足您的特定需求。使用我们的绕线机，您可以获得高效且易于使用的设备，确保连续的高质量生产。此外，为了补充您的制造过程，我们还提供不同类型的高质量和耐用的纱线，以供给您的绕线机，确保我们的客户拥有所有必要的材料，以实现高效和一致的生产。"
                    ],
                ],

                '22' => [
                    'name' => [
                        "Máquinas de agujas",
                        "Needle machines",
                        "Macchine per aghi",
                        "Máquinas de Crochê",
                        "Machines à aiguilles",
                        "针织机 (Zhēnzhī jī)"
                    ],
                    'description' => [
                        "Nuestra máquina de agujas es ideal para quienes desean iniciar la producción de encajes. Esta versátil máquina no solo puede producir cordones de alta calidad, sino que también se puede adaptar a diferentes necesidades de producción. Perfecta para talleres y fábricas, esta máquina puede maximizar tu capacidad de producción. Además, ofrecemos asesoramiento personalizado y soporte técnico para garantizar una implementación fluida y exitosa.",
                        "Our needle machine is ideal for those who want to start lace production. This versatile machine can not only produce high quality laces, but can also be adapted to different production needs.\nPerfect for workshops and factories, this machine can maximize your production capacity. In addition, we offer personalized advice and technical support to ensure a smooth and successful implementation.",
                        "La nostra macchina ad aghi è ideale per chi desidera avviare la produzione di pizzi. Questa versatile macchina non solo può produrre pizzi di alta qualità, ma può anche essere adattata a diverse esigenze di produzione. Perfetta per laboratori e fabbriche, questa macchina può massimizzare la tua capacità produttiva. Inoltre, offriamo consulenza personalizzata e supporto tecnico per garantire un'implementazione fluida e di successo.",
                        "Nossa máquina de agulhas é ideal para quem deseja iniciar a produção de rendas. Esta máquina versátil pode não só produzir rendas de alta qualidade, mas também pode ser adaptada a diferentes necessidades de produção. Perfeita para oficinas e fábricas, esta máquina pode maximizar sua capacidade de produção. Além disso, oferecemos consultoria personalizada e suporte técnico para garantir uma implementação tranquila e bem-sucedida.",
                        "Notre machine à aiguilles est idéale pour ceux qui souhaitent démarrer la production de dentelle. Cette machine polyvalente peut non seulement produire des dentelles de haute qualité, mais elle peut également être adaptée à différents besoins de production. Parfaite pour les ateliers et les usines, cette machine peut maximiser votre capacité de production. De plus, nous offrons des conseils personnalisés et un support technique pour garantir une mise en œuvre fluide et réussie.",
                        "我们的针织机是想要开始花边生产的理想选择。这款多功能机器不仅可以生产高质量的花边，还可以根据不同的生产需求进行调整。 非常适合车间和工厂，这款机器可以最大化您的生产能力。此外，我们还提供个性化建议和技术支持，以确保顺利和成功的实施。"
                    ],
                ],

                '23' => [
                    'name' => [
                        "Máquinas para engomado",
                        "Sizing Machine",
                        "Macchina per dimensionamento",
                        "Engomadeiras",
                        "Machine de dimensionnement",
                        "定型机 (Dìngxíng jī)"
                    ],
                    'description' => [
                        "Nuestras máquinas de engomado son la solución ideal para engomar algodón, hilo de poliéster, fibra mezclada y otros materiales. Diseñadas para cumplir con los más altos estándares de calidad, estas máquinas garantizan un engomado uniforme y eficiente. Lo mejor de todo es que podemos personalizar cada máquina según tus requisitos específicos de producción, asegurando que se adapte perfectamente a tus necesidades. Con nuestras máquinas de engomado, obtienes un rendimiento superior y una mayor durabilidad de los hilos tratados, optimizando tu proceso de fabricación. Confía en nuestros expertos para brindarte asesoramiento técnico y un servicio integral, desde la instalación hasta el soporte postventa. Nuestro equipo de ventas está disponible para recomendar la máquina adecuada según las necesidades de producción específicas de cada cliente, y proporcionamos un servicio completo de consultoría postventa para garantizar el máximo rendimiento de tu equipo.",
                        "Our sizing machines are the ideal solution for gumming cotton, polyester yarn, blended fiber and other materials. Designed to meet the highest quality standards, these machines ensure uniform and efficient gumming. Best of all, we can customize each machine to your specific production requirements, ensuring that it is perfectly suited to your needs.\nWith our gumming machines, you get superior performance and increased durability of treated yarns, optimizing your manufacturing process. Rely on our experts to provide you with technical advice and comprehensive service, from installation to after-sales support.\nOur sales team is available to recommend the right machine according to each customer's specific production needs, and we provide a complete after-sales consulting service to ensure maximum performance of your equipment.",
                        "Le nostre macchine per l'apprettatura sono la soluzione ideale per l'incollaggio di cotone, filato di poliestere, fibre miste e altri materiali. Progettate per soddisfare i più alti standard di qualità, queste macchine garantiscono un incollaggio uniforme ed efficiente. La cosa migliore è che possiamo personalizzare ogni macchina in base alle tue specifiche esigenze di produzione, assicurando che sia perfettamente adatta alle tue necessità. Con le nostre macchine per l'apprettatura, ottieni prestazioni superiori e una maggiore durata dei filati trattati, ottimizzando il tuo processo di produzione. Affidati ai nostri esperti per fornirti consulenza tecnica e un servizio completo, dall'installazione al supporto post-vendita. Il nostro team di vendita è disponibile per raccomandare la macchina giusta in base alle specifiche esigenze di produzione di ciascun cliente e offriamo un servizio di consulenza post-vendita completo per garantire il massimo rendimento del tuo equipaggiamento.",
                        "Nossas máquinas de engomagem são a solução ideal para engomar algodão, fio de poliéster, fibra mista e outros materiais. Projetadas para atender aos mais altos padrões de qualidade, essas máquinas garantem uma engomagem uniforme e eficiente. O melhor de tudo é que podemos personalizar cada máquina de acordo com os seus requisitos específicos de produção, garantindo que seja perfeitamente adequada às suas necessidades. Com nossas máquinas de engomagem, você obtém um desempenho superior e uma maior durabilidade dos fios tratados, otimizando seu processo de fabricação. Confie em nossos especialistas para lhe fornecer consultoria técnica e um serviço completo, desde a instalação até o suporte pós-venda. Nossa equipe de vendas está disponível para recomendar a máquina certa de acordo com as necessidades específicas de produção de cada cliente e oferecemos um serviço completo de consultoria pós-venda para garantir o máximo desempenho do seu equipamento.",
                        "Nos machines d'encollage sont la solution idéale pour l'encollage du coton, du fil de polyester, des fibres mélangées et d'autres matériaux. Conçues pour répondre aux normes de qualité les plus élevées, ces machines garantissent un encollage uniforme et efficace. Le meilleur de tout, c'est que nous pouvons personnaliser chaque machine en fonction de vos besoins spécifiques de production, assurant qu'elle soit parfaitement adaptée à vos exigences. Avec nos machines d'encollage, vous obtenez des performances supérieures et une durabilité accrue des fils traités, optimisant ainsi votre processus de fabrication. Faites confiance à nos experts pour vous fournir des conseils techniques et un service complet, de l'installation au support après-vente. Notre équipe commerciale est disponible pour recommander la machine adaptée aux besoins spécifiques de production de chaque client, et nous offrons un service complet de conseil après-vente pour garantir les meilleures performances de votre équipement.",
                        "我们的上浆机是对棉花、涤纶纱线、混纺纤维和其他材料进行上浆的理想解决方案。这些机器设计符合最高质量标准，确保均匀、高效的上浆。最重要的是，我们可以根据您的具体生产需求定制每台机器，确保其完全符合您的要求。 使用我们的上浆机，您将获得优越的性能和增加的纱线耐久性，从而优化您的制造过程。您可以依靠我们的专家为您提供技术建议和全面的服务，从安装到售后支持。 我们的销售团队随时可以根据每个客户的具体生产需求推荐合适的机器，并提供完整的售后咨询服务，以确保您的设备达到最佳性能。"
                    ],
                ],

                '24' => [
                    'name' => [
                        "Máquina Rama",
                        "Stenter Machine",
                        "Macchina per finissaggio (termofissatrice)",
                        "Rama",
                        "Machine à rames",
                        "定型机"

                    ],
                    'description' => [
                        "Obtén el acabado perfecto para tus telas con nuestra máquina rama. Disponible en configuraciones verticales y horizontales, esta máquina es ideal para telas tejidas y de punto, así como para una amplia gama de telas, incluyendo algodón, poliéster-algodón, poliéster y telas elásticas después de procesos como el desengomado y el mercerizado.\nOfrecemos esta máquina en diferentes anchos para adaptarse a tus necesidades específicas. Además, brindamos asesoramiento personalizado para garantizar que selecciones la máquina perfecta para tu producción. Para más información y asistencia personalizada, por favor contacta a tu representante de ventas.",
                        "Get the perfect finish for your fabrics with our Stenter setting machine. Available in vertical and horizontal configurations, this machine is ideal for knitted and woven fabrics, as well as a wide range of fabrics, including cotton, poly cotton, polyester and elastic fabrics after processes such as desizing and mercerizing.\nWe offer this machine in different widths to suit your specific needs. In addition, we provide personalized advice to ensure that you select the perfect machine for your production. For more information and personalized assistance, please contact your sales representative.",
                        "Ottieni la finitura perfetta per i tuoi tessuti con la nostra macchina di regolazione Stenter. Disponibile in configurazioni verticali e orizzontali, questa macchina è ideale per tessuti a maglia e tessuti intrecciati, nonché per una vasta gamma di tessuti, tra cui cotone, poliestere-cotone, poliestere e tessuti elastici dopo processi come desizing e mercerizzazione.\nOffriamo questa macchina in diverse larghezze per soddisfare le tue esigenze specifiche. Inoltre, offriamo consulenza personalizzata per garantire che tu scelga la macchina perfetta per la tua produzione. Per ulteriori informazioni e assistenza personalizzata, contatta il tuo rappresentante di vendita.",
                        "Obtenha o acabamento perfeito para seus tecidos com nossa máquina de ajuste Stenter. Disponível em configurações verticais e horizontais, esta máquina é ideal para tecidos tricotados e tecidos entrelaçados, bem como para uma ampla gama de tecidos, incluindo algodão, poliéster-algodão, poliéster e tecidos elásticos após processos como desengomagem e mercerização.\nOferecemos esta máquina em diferentes larguras para atender às suas necessidades específicas. Além disso, fornecemos consultoria personalizada para garantir que você escolha a máquina perfeita para sua produção. Para mais informações e assistência personalizada, entre em contato com seu representante de vendas.",
                        "Obtenez la finition parfaite pour vos tissus avec notre machine de réglage Stenter. Disponible en configurations verticales et horizontales, cette machine est idéale pour les tissus tricotés et tissés, ainsi que pour une large gamme de tissus, y compris le coton, le polycoton, le polyester et les tissus élastiques après des processus tels que le désencollage et la mercerisation.\nNous proposons cette machine en différentes largeurs pour répondre à vos besoins spécifiques. De plus, nous offrons des conseils personnalisés pour vous assurer de choisir la machine parfaite pour votre production. Pour plus d'informations et une assistance personnalisée, veuillez contacter votre représentant commercial.",
                        "使用我们的拉幅定型机为您的面料获得完美的整理效果。该机器有垂直和水平配置，可用于针织和机织面料，以及广泛的面料类型，包括棉布、涤棉布、涤纶布和弹性面料，特别适用于退浆和丝光工艺后。我们提供不同宽度的机器，以满足您的特定需求。此外，我们提供个性化建议，以确保您选择最适合生产的机器。欲了解更多信息和个性化服务，请联系您的销售代表。",
                        ""
                    ],
                ],

                '25' => [
                    'name' => [
                        "Jigger de tintura",
                        "Dye Jigger",
                        "Jigger per tintura",
                        "Jigger",
                        "Jigger de teinture",
                        "染色夹 (Rǎnsè jiā)"
                    ],
                    'description' => [
                        "Descubre nuestras máquinas jigger para el sector de tintorería, diseñadas principalmente para trabajar con nylon, seda, spandex, algodón, poliéster, lino y tejidos mezclados en desengrase, blanqueo, limpieza, teñido y más. Estas máquinas aseguran una verdadera tensión superficial del tejido, inspección de velocidad lineal y control en circuito cerrado. Algunos modelos cuentan con rodillos para tejidos, lo que los hace ideales para diferentes tipos de telas en tratamientos previos y posteriores a temperatura normal. Para una recomendación personalizada sobre el tipo de jigger que necesitas, contacta a tu representante de ventas.",
                        "Discover our jigger machines for the dyeing sector, designed mainly to work with nylon, silk spandex, cotton, polyester, linen and blended fabrics in desizing, bleaching, cleaning, dyeing and more. These machines ensure true direct fabric surface tension, linear speed inspection and closed loop control.\nSome models feature fabric rollers, making them ideal for different types of fabrics in normal temperature pre and post treatments.\nFor a customized recommendation on the type of jigger you need, please contact your sales representative.",
                        "Scopri le nostre macchine jigger per il settore della tintura, progettate principalmente per lavorare con nylon, seta, spandex, cotone, poliestere, lino e tessuti misti in disincrassaggio, sbiancamento, pulizia, tintura e altro. Queste macchine garantiscono una vera tensione superficiale del tessuto, ispezione della velocità lineare e controllo a circuito chiuso. Alcuni modelli dispongono di rulli per tessuti, rendendoli ideali per diversi tipi di tessuti nei trattamenti pre e post a temperatura normale. Per una raccomandazione personalizzata sul tipo di jigger di cui hai bisogno, contatta il tuo rappresentante commerciale.",
                        "Descubra nossas máquinas jigger para o setor de tingimento, projetadas principalmente para trabalhar com nylon, seda, spandex, algodão, poliéster, linho e tecidos mistos em desengorduramento, branqueamento, limpeza, tingimento e muito mais. Essas máquinas garantem uma verdadeira tensão superficial do tecido, inspeção da velocidade linear e controle em circuito fechado. Alguns modelos possuem rolos para tecidos, tornando-os ideais para diferentes tipos de tecidos em tratamentos pré e pós a temperatura normal. Para uma recomendação personalizada sobre o tipo de jigger que você precisa, entre em contato com seu representante de vendas.",
                        " Découvrez nos machines jigger pour le secteur de la teinture, conçues principalement pour travailler avec du nylon, de la soie, du spandex, du coton, du polyester, du lin et des tissus mélangés dans les opérations de désencollage, de blanchiment, de nettoyage, de teinture, etc. Ces machines assurent une véritable tension de surface du tissu, une inspection de la vitesse linéaire et un contrôle en boucle fermée. Certains modèles sont équipés de rouleaux pour tissus, ce qui les rend idéaux pour différents types de tissus dans les traitements pré et post à température normale. Pour une recommandation personnalisée sur le type de jigger dont vous avez besoin, veuillez contacter votre représentant commercial.",
                        "了解我们的染色行业专用的 jigger 机器，这些机器主要用于处理尼龙、丝绸、氨纶、棉花、聚酯纤维、亚麻和混合面料的去浆、漂白、清洗、染色等过程。这些机器确保真正的织物表面张力、线速度检查和闭环控制。部分型号配备了面料辊，适用于不同类型的织物在常温下的预处理和后处理。若需针对您所需的 jigger 类型的定制建议，请联系您的销售代表。",
                    ],
                ],


                // '11' => [
                //     'name' => [

                //     ],
                //     'description' => [

                //     ],
                // ],
            ];


            foreach ($machines as $key => $machine) {
                foreach ($machine['name'] as $index => $name) {
                    $description = $machine['description'][$index];

                    DB::table('machine_translations')->insert([
                        // 'id' => $index,
                        'name' => $name,
                        'description' => $description,
                        'machine_id' => $key,
                        'language_id' =>  $index + 1,
                        'created_at' => now(),
                        'updated_at' => now(),
                    ]);
                }
            }
        }
    }
}
