<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class ProductSectorSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {

        // Check if we are sowing or reversing
        $rollback = env('SEED_ROLLBACK', false);

        if ($rollback) {
            // Temporarily disable foreign key restrictions
            DB::statement('SET FOREIGN_KEY_CHECKS = 0;');
            // Delete all languages
            DB::table('product_sectors')->truncate();
        } else {
            //inserting lemnguages


            $sectors = [
                '1' =>  [
                    'name' => "itg-line",
                    'image' => "Itg-line/Rectangle 250.png",
                    'img_banner' => "Itg-line/Banner ITG Line.png",
                ],
                '2' =>  [
                    'name' => "weaving",
                    'image' => "Weaving/Rectangle 126.png",
                    'img_banner' => "Weaving/HEADER - Weaving.png",
                ],
                '3' =>  [
                    'name' => "knitting",
                    'image' => "Knitting/Rectangle 126 (3).png",
                    'img_banner' => "Knitting/HEADER - KNITTING.png",
                ],
                '4' =>  [
                    'name' => "braiding",
                    'image' => "Braiding/Rectangle 126 (2).png",
                    'img_banner' => "Braiding/HEADER - BRAIDING.png",
                ],
                // '5' =>  [
                //     'name' => "warping",
                //     'image' => "asd132er123eqsdaadsdasd12e1dadsdfdst3456745ye.jpg",
                //     'img_banner' => "asd132er123eqsdaadsdasd12e1dadsdfdst3456745ye.jpg",
                // ],
                // '6' =>  [
                //     'name' => "dying",
                //     'image' => "asd132er123eqsdaadsdasd12e1dadsdfdst3456745ye.jpg",
                //     'img_banner' => "asd132er123eqsdaadsdasd12e1dadsdfdst3456745ye.jpg",
                // ],
                // '7' =>  [
                //     'name' => "labeling",
                //     'image' => "asd132er123eqsdaadsdasd12e1dadsdfdst3456745ye.jpg",
                //     'img_banner' => "asd132er123eqsdaadsdasd12e1dadsdfdst3456745ye.jpg",
                // ],
                '8' =>  [
                    'name' => "yarn",
                    'image' => "Yarn/Group 294.png",
                    'img_banner' => "Yarn/HEADER - YARN.png",
                ],
                '9' =>  [
                    'name' => "general",
                    'image' => "General equipment/Group 254.png",
                    'img_banner' => "General equipment/Group 255.png",
                ]
            ];


            foreach ($sectors as  $key => $sector) {
                DB::table('product_sectors')->insert([
                    'id' =>  $key,
                    'name' =>  $sector["name"],
                    'image' =>  $sector["image"],
                    'img_banner' => $sector["img_banner"],
                    'created_at' => now(),
                    'updated_at' => now(),
                ]);
            }
        }
    }
}
