<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;


class SpecialtyTranslationSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {

        // Check if we are sowing or reversing
        $rollback = env('SEED_ROLLBACK', false);

        if ($rollback) {
            // Temporarily disable foreign key restrictions
            DB::statement('SET FOREIGN_KEY_CHECKS = 0;');
            // Truncate all divisions
            DB::table('specialty_translations')->truncate();
        } else {

            //? languageS -------------   [1] = Español, [2] 2 = Inglés, [3]  3 = Italiano, [4]  4 = Portugués, [5]   5 = Francés, [6]  6 = Chino ------------------------------

            //inserting specialty
            $specialties = [
                '1' =>  ["Marketing", "Marketing", "Marketing", "Marketing", "Marketing", "营销"],
                '2' =>  ["Administración", "Administration", "Amministrazione", "Administração", "Administration", "管理"],

            ];


            foreach ($specialties as $key => $specialty) {
                foreach ($specialty as $position => $translation) {
                    DB::table('specialty_translations')->insert([
                        'name_translation'  => $translation,
                        'language_id' =>  $position+1,
                        'specialty_id' =>  $key,
                        'created_at' => now(),
                        'updated_at' => now(),
                    ]);
                }
            }
        }
    }
}
