@php
// Obtener los testimonios traducidos
$testimonials = __('testimonials.review');

// Filtrar testimonios para la división seleccionada
$divisionTestimonials = collect($testimonials)->filter(function ($item) use ($division) {
    return in_array($division->name, $item['division']);
})->flatMap(function ($item) {
    return $item['testimonials'];
});
@endphp

@if ($divisionTestimonials->isNotEmpty())
<section class="testimonial-section-three" style="background-image:url(images/background/map.png); z-index:2;">
    <div class="auto-container">
        <!-- Sec Title -->
        <div class="sec-title alternate centered">
            <div class="title text-white">{{ __('messages.our-testimonial') }}</div>
            <h2 class="color-yellow1">{{ __('messages.title-our-testimonial') }}</h2>
        </div>
        <div class="three-item-carousel-two owl-carousel owl-theme">
            @foreach ($divisionTestimonials as $review)
                <!-- Testimonial Block Two -->
                <div class="testimonial-block-two">
                    <div class="inner-box">
                        <div class="author-box">
                            <div class="author-inner">
                                {{-- <div class="author-image">
                                    <img src="{{ asset('images/icons/user.png') }}" alt="" />
                                </div> --}}
                                <strong>{{ $review['name'] }}</strong>
                            </div>
                        </div>
                        <div class="text">{{ $review['text'] }}</div>
                    </div>
                </div>
            @endforeach
        </div>
    </div>
</section>
@endif
