<div>
    @if (session('messageSuccess'))
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            <strong>{{ session('messageSuccess') }} </strong>
            <button type="button" class="btn-close" data-dismiss="alert" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
        </div>
    @elseif (session('error_message'))
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            <strong>{{ session('error_message') }} </strong>
            <button type="button" class="btn-close" data-dismiss="alert" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
        </div>
    @endif

    <div wire:loading.flex style="display: none">
        <div class="cont-loader">
            <div class="loader"></div>
        </div>
    </div>

    <!--Comment Form-->
    <form wire:submit.prevent="store" novalidate="novalidate" class="form">
        <div class="row clearfix">
            <div class="col-lg-6 col-md-6 col-sm-12 form-group">
                <label for="division" class="form-label text-dark">{{ __('messages.careers-label1') }} </label>
                <select wire:model="division" id="division">
                    <option value="">{{ __('messages.careers-input1') }} </option>
                    @foreach ($divisions as $division)
                        <option value="{{ $division->id }}">{{ $division->name }} </option>
                    @endforeach
                </select>

                @error('division')
                    <div class="alert alert-danger my-2 rounded-lg">
                        {{ $message }}
                    </div>
                @enderror

            </div>
            <div class="col-lg-6 col-md-6 col-sm-12 form-group">

                <label for="specialty" class="form-label text-dark">{{ __('messages.careers-label2') }} </label>
                <select wire:model="specialty" id="specialty">
                    <option value="">{{ __('messages.careers-input2') }} </option>
                    @foreach ($specialties as $specialty)
                        <option value="{{ $specialty->id }}">{{ $specialty->translation->name_translation }} </option>
                    @endforeach
                </select>

                @error('specialty')
                    <div class="alert alert-danger my-2 rounded-lg">
                        {{ $message }}
                    </div>
                @enderror
            </div>
            <div class="col-lg-6 col-md-6 col-sm-12 form-group">
                <label for="email" class="form-label text-dark">{{ __('messages.careers-label3') }} </label>
                <input type="email" wire:model="email" id="email"
                    placeholder="{{ __('messages.careers-input3') }}">

                @error('email')
                    <div class="alert alert-danger my-2 rounded-lg">
                        {{ $message }}
                    </div>
                @enderror
            </div>
            <div class="col-lg-6 col-md-6 col-sm-12 form-group">
                <label for="name" class="form-label text-dark">{{ __('messages.careers-label4') }} </label>
                <input type="text" wire:model="name" id="name"
                    placeholder="{{ __('messages.careers-input4') }}">
                @error('name')
                    <div class="alert alert-danger my-2 rounded-lg">
                        {{ $message }}
                    </div>
                @enderror
            </div>
            <div class="col-lg-12 col-md-12 col-sm-12 form-group">
                <label for="messageEmail" class="form-label text-dark">{{ __('messages.careers-label5') }} </label>
                <textarea class="" wire:model="messageEmail" id="messageEmail" placeholder="{{ __('messages.careers-input5') }}"></textarea>
                @error('messageEmail')
                    <div class="alert alert-danger my-2 rounded-lg">
                        {{ $message }}
                    </div>
                @enderror
            </div>
            <div class="col-lg-6 col-md-6 col-sm-12 form-group">
                <label for="cv" class="form-label text-dark">{{ __('messages.careers-label6') }} </label>


                <div class="file-upload-wrapper"
                    data-text="{{ $cv ? $cv->getClientOriginalName() : __('messages.careers-input6') }}">
                    <input name="file-upload-field" type="file" class="file-upload-field" wire:model="cv"
                        id="cv" value="">
                    <span class="upload-text">{{ __('messages.upload') }} </span>
                </div>

                @error('cv')
                    <div class="alert alert-danger my-2 rounded-lg">
                        {{ $message }}
                    </div>
                @enderror
            </div>
            <div class="col-lg-12 col-md-12 col-sm-12 form-group">
                <button class="theme-btn btn-style-one" type="submit" wire:loading.attr="disabled">
                    <span class="txt">{{ __('messages.careers-btn-submit') }}<i
                            class="fa fa-angle-right"></i></span></button>
            </div>
        </div>
    </form>
</div>
