@extends('layouts.general')

@section('main_content')
    {{-- NAVIGATION --}}
    <section class="page-title"
        style="background-image: url({{ asset('images/machinery/general/General-Machinery/Header.png') }}" id="about">
        <div class="auto-container">
            <h1 class="d-none">Catalog of Machinery for Sale</h1>
            <ul class="bread-crumb clearfix">
                <li><a href="{{ route('home.index') }}">{{ __('messages.home') }} </a></li>
                <li>{{ __('messages.machinery') }} </li>
            </ul>
            <h2>{{ __('messages.machinery') }} </h2>
        </div>
    </section>>
    <!-- End Page Title -->

    <!-- Project Page Section -->
    <div class="project-page-section">
        {{-- <div class="pattern-layer" style="background-image:url({{ asset('images/background/pattern-9.png') }}"></div> --}}
        <div class="auto-container">
            <div class="sec-title alternate centered">
                <div class="title style-two text-dark">{{ __('messages.machinery-title') }} </div>
                <h3 class="_h2 color-green1">{{ __('messages.machinery-subtitle') }} </h3>
            </div>
            <!-- MixitUp Galery -->
            <div class="mixitup-gallery">
                <!-- Filter -->
                <div class="filters clearfix">
                    <ul class="filter-tabs filter-btns text-center clearfix">
                        <a href="{{ route('machinery.index') }}">
                            <li class="@if ($condition == 0) active @endif  filter"> {{ __('messages.new') }}
                            </li>
                        </a>
                        <a href="javascript:void(0;)">
                            <li class="filter"> {{ __('messages.used') }} </li>
                        </a>
                    </ul>
                </div>

                <div class="filters clearfix">
                    <ul class="filter-tabs filter-btns text-center clearfix">
                        <a href="{{ route('machinery.index') }}">
                            <li class="@if (empty($category)) active @endif  filter">
                                {{ __('messages.view-all') }} </li>
                        </a>
                        @foreach ($categories as $categoryF)
                            <a href="{{ route('machinery.category', $categoryF) }}">
                                <li class="@if ($category && $categoryF->id == $category->id) active @endif  filter">
                                    {{ $categoryF->translation->name }} </li>
                            </a>
                        @endforeach
                    </ul>
                </div>

                <div class="filter-list row clearfix justify-content-center">
                    @forelse ($machines as $machine)
                        <div class="project-block-two mix all col-lg-6 col-md-6 col-sm-12">
                            <div class="inner-box">
                                <div class="image">
                                    <img src="{{ asset('images/' . $machine->main_image) }}" alt="" />
                                    <div class="overlay-box">
                                        <a class="plus flaticon-plus" href="{{ route('machinery.show', $machine) }}"></a>
                                        <div class="content">
                                            <div class="title">{{ $machine->machineCategory->translation->name }} </div>
                                            <div class="pr-5">
                                                <h4><a href="{{ route('machinery.show', $machine) }}">{{ $machine->translation->name }}
                                                    </a></h4>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    @empty
                        <p>{!! __('messages.no-machinery') !!} </p>
                    @endforelse
                </div>

                <div class="mt-10 d-flex justify-content-end">
                    {{ $machines->links('vendor.pagination.blog') }}
                </div>
            </div>
        </div>
    </div>
@endsection

@push('styles')
    <style>
        .project-block-two .inner-box .overlay-box:before {
            opacity: 0.52;
            background-color: var(--black-color);
        }

        .project-page-section .filters li {
            background: var(--color-green-one);
            color: var(--white-color);
        }
    </style>
@endpush
