<?php $__env->startSection('main_content'); ?>
    
    <section class="page-title"
        style="background-image: url(<?php echo e(asset('/images/machinery/general/General-Machinery/Header.png')); ?>" id="about">
        <div class="auto-container">
            <h1 class="d-none">Sale of - <?php echo e($machine->translation->name); ?></h1>
            <ul class="bread-crumb clearfix">
                <li><a href="<?php echo e(route('home.index')); ?>"><?php echo e(__('messages.home')); ?> </a></li>
                <li> <a
                        href="<?php echo e(route('machinery.category', $machine->machineCategory)); ?>"><?php echo e(__('messages.machinery')); ?></a>
                </li>
            </ul>
            <h2> <?php echo e($machine->translation->name); ?> </h2>
        </div>
    </section>>
    <!-- End Page Title -->
    <div class="project-detail-section">
        <div class="auto-container">
            <!-- Upper Box -->
            <div class="upper-box">
                <div class="image">
                    <img src="<?php echo e(asset('images/' . $machine->main_image)); ?>" alt="" />
                </div>
                <!-- Info Box -->
                <div class="info-box">
                    <div class="title"><?php echo e(__('messages.details')); ?> </div>
                    <ul class="info-list list-value">
                        <p class="model-title"><?php echo e(__('messages.model')); ?> </p>
                        <?php if(
                            $machine->machineDetails->isEmpty() ||
                                $machine->machineDetails->every(fn($detail) => empty($detail->translation->description))): ?>
                            <li class="color-black1"> <?php echo e(__('messages.no-detail')); ?></li>
                        <?php else: ?>
                            <?php $__currentLoopData = $machine->machineDetails; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $detail): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php if(!empty($detail->translation->description)): ?>
                                    <li class="color-black1"><?php echo e($detail->translation->description); ?></li>
                                <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>
                    </ul>
                </div>
            </div>
            <!-- End Upper Box -->

            <!-- Middle Box -->
            <div class="middle-box">
                <h3> <?php echo e($machine->translation->name); ?> </h3>
                <p> <?php echo e($machine->translation->description); ?> </p>
                <div class="gallery-box">
                    <div class="row clearfix">
                        <?php $__currentLoopData = $machine->machineImages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="col-lg-4 col-md-4 col-sm-12">
                                <div class="image">
                                    <img src="<?php echo e(asset('images/' . $image->image)); ?>" alt="" />
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>

                <?php echo $__env->make('machinery.machinery-video', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                <h4><?php echo e(__('messages.main-features')); ?> </h4>
                <div class="row clearfix">
                    <?php $__currentLoopData = $machine->machineFeatures->chunk(ceil($machine->machineFeatures->count() / 2)); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $div): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="col-lg-6 col-md-12 col-sm-12">
                            <ul class="option-list">
                                <?php $__currentLoopData = $div; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $feature): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li><?php echo e($feature->translation->description); ?> </li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
                <?php echo $__env->make('machinery.braiding-complementary', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>


                <?php if(in_array($machine->name, ['braiding-machines', 'needle-machines', 'winding-machines', 'tipping-machines']) &&
                        $division->name == 'mexico'): ?>
                    <?php echo $__env->make('components.agent.henghui', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <?php endif; ?>




                <?php if(in_array($machine->name, ['sectional-warping-machine', 'direct-warping-machines']) &&
                        ($division->name == 'colombia' || $division->name == 'argentina')): ?>
                    <?php echo $__env->make('components.agent.comsat', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <?php endif; ?>


                <div>
                    <h3><?php echo e(__('messages.more-information')); ?> </h3>
                    <div class="row py-3">
                        <div class="col-6 col-md-3">
                            <a href="#" data-toggle="modal" class="btn-web-catalog"
                                style="color: var(--white-color) !important;"
                                data-target="#catalogueContact"><?php echo e(__('messages.data-sheet')); ?> </a>

                        </div>
                        <div class="col-6 col-md-3">
                            <a class="btn-web-catalog" style="color: var(--white-color) !important;"
                                href="<?php echo e(route('contact.index')); ?>#contactform"><?php echo e(__('messages.ask-quotation')); ?> </a>
                        </div>
                    </div>

                    <?php if(in_array($machine->id, $representation)): ?>
                        <div class="welcome-section style-two">
                            <div class="row clearfix">
                                <!-- Content Column -->
                                <div class="content-column col-lg-7 col-md-7 col-sm-12">
                                    <div class="inner-column">
                                        <!-- Quality Box -->
                                        <div class="quality-box">
                                            <div class="quality-inner">
                                                <span class="icon flaticon-trophy-2"></span>
                                                <h4><?php echo e(__('messages.offi-representation')); ?> </h4>
                                                <div class="text"><?php echo e(__('messages.offic-repre-text')); ?> </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>

        <!-- Modal para el formulario de descarga PDF-->
        <?php if (isset($component)) { $__componentOriginale6a555649da86b3de44465cdfe004aa4 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginale6a555649da86b3de44465cdfe004aa4 = $attributes; } ?>
<?php $component = App\View\Components\Modal::resolve(['modalId' => 'catalogueContact','title' => ''.e(__('messages.download-now')).''] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('modal'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\Modal::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
            <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('catalogue-contact-form', ['product_name' => $machine->name, 'product_type' => 'machinery', 'dataDivision' => $division, 'urlCatalogue' => $machine->cataloguePdf->url ?? null]);

$__html = app('livewire')->mount($__name, $__params, 'lw-2159100012-0', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
         <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginale6a555649da86b3de44465cdfe004aa4)): ?>
<?php $attributes = $__attributesOriginale6a555649da86b3de44465cdfe004aa4; ?>
<?php unset($__attributesOriginale6a555649da86b3de44465cdfe004aa4); ?>
<?php endif; ?>
<?php if (isset($__componentOriginale6a555649da86b3de44465cdfe004aa4)): ?>
<?php $component = $__componentOriginale6a555649da86b3de44465cdfe004aa4; ?>
<?php unset($__componentOriginale6a555649da86b3de44465cdfe004aa4); ?>
<?php endif; ?>
    <?php $__env->stopSection(); ?>

    <?php $__env->startPush('styles'); ?>
        <style>
            .model-title {
                font-size: var(--font-20);
                font-weight: bold;
            }

            .btn-style-one {
                background-color: var(--color-green-one);
            }
        </style>
    <?php $__env->stopPush(); ?>



    <?php $__env->startPush('scripts'); ?>
        <script>
            $('#catalogueContact').on('hidden.bs.modal', function(e) {
                $(this).find('form').trigger('reset');
                $(this).find('.alert-danger').remove();
            });

            Livewire.on('postForm', function() {
                $('#catalogueContact').modal('hide');
                $('#catalogueContact').on('hidden.bs.modal', function() {
                    $(this).find('form').trigger('reset');
                });
            });
        </script>
    <?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.general', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/group-itg.com/resources/views/machinery/machinery-show.blade.php ENDPATH**/ ?>