<?php
// Obtener los testimonios traducidos
$testimonials = __('testimonials.review');

// Filtrar testimonios para la división seleccionada
$divisionTestimonials = collect($testimonials)->filter(function ($item) use ($division) {
    return in_array($division->name, $item['division']);
})->flatMap(function ($item) {
    return $item['testimonials'];
});
?>

<?php if($divisionTestimonials->isNotEmpty()): ?>
<section class="testimonial-section-three" style="background-image:url(images/background/map.png); z-index:2;">
    <div class="auto-container">
        <!-- Sec Title -->
        <div class="sec-title alternate centered">
            <div class="title text-white"><?php echo e(__('messages.our-testimonial')); ?></div>
            <h2 class="color-yellow1"><?php echo e(__('messages.title-our-testimonial')); ?></h2>
        </div>
        <div class="three-item-carousel-two owl-carousel owl-theme">
            <?php $__currentLoopData = $divisionTestimonials; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $review): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <!-- Testimonial Block Two -->
                <div class="testimonial-block-two">
                    <div class="inner-box">
                        <div class="author-box">
                            <div class="author-inner">
                                
                                <strong><?php echo e($review['name']); ?></strong>
                            </div>
                        </div>
                        <div class="text"><?php echo e($review['text']); ?></div>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
</section>
<?php endif; ?>
<?php /**PATH /var/www/html/group-itg.com/resources/views/components/testimonials.blade.php ENDPATH**/ ?>